/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.energy;

import com.builtbroken.mc.api.energy.IEnergyBuffer;
import com.builtbroken.mc.api.energy.IEnergyBufferProvider;
import com.builtbroken.mc.api.items.energy.IEnergyBufferItem;
import com.builtbroken.mc.api.items.energy.IEnergyItem;
import com.builtbroken.mc.api.tile.ConnectionType;
import com.builtbroken.mc.api.tile.ITileConnection;
import com.builtbroken.mc.framework.energy.EnergyHandler;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class UniversalEnergyHandler
extends EnergyHandler {
    public UniversalEnergyHandler() {
        super("ue", "watts", "watts", 1.0);
    }

    @Override
    public double receiveEnergy(Object handler, ForgeDirection direction, double energy, boolean doReceive) {
        IEnergyBuffer buffer;
        if (handler instanceof ItemStack) {
            return this.chargeItem((ItemStack)handler, energy, doReceive);
        }
        if (handler instanceof IEnergyBufferProvider && (buffer = ((IEnergyBufferProvider)handler).getEnergyBuffer(direction)) != null) {
            int floor = (int)Math.floor(energy);
            return buffer.addEnergyToStorage(floor, doReceive);
        }
        return 0.0;
    }

    @Override
    public double extractEnergy(Object handler, ForgeDirection direction, double energy, boolean doExtract) {
        IEnergyBuffer buffer;
        if (handler instanceof ItemStack) {
            return this.dischargeItem((ItemStack)handler, energy, doExtract);
        }
        if (handler instanceof IEnergyBufferProvider && (buffer = ((IEnergyBufferProvider)handler).getEnergyBuffer(direction)) != null) {
            int floor = (int)Math.floor(energy);
            return buffer.removeEnergyFromStorage(floor, doExtract);
        }
        return 0.0;
    }

    @Override
    public double chargeItem(ItemStack itemStack, double joules, boolean docharge) {
        if (itemStack.func_77973_b() instanceof IEnergyItem) {
            int floor = (int)Math.floor(joules);
            return ((IEnergyItem)itemStack.func_77973_b()).recharge(itemStack, floor, docharge);
        }
        if (itemStack.func_77973_b() instanceof IEnergyBufferItem) {
            int e = ((IEnergyBufferItem)itemStack.func_77973_b()).getEnergyCapacity(itemStack);
            int roomLeft = -((IEnergyBufferItem)itemStack.func_77973_b()).getEnergy(itemStack);
            if (joules >= (double)roomLeft) {
                if (docharge) {
                    ((IEnergyBufferItem)itemStack.func_77973_b()).setEnergy(itemStack, e + roomLeft);
                }
                return roomLeft;
            }
            int newEnergy = (int)Math.floor((double)e + joules);
            int added = newEnergy - e;
            if (docharge) {
                ((IEnergyBufferItem)itemStack.func_77973_b()).setEnergy(itemStack, newEnergy);
            }
            return added;
        }
        return 0.0;
    }

    @Override
    public double dischargeItem(ItemStack itemStack, double joules, boolean doDischarge) {
        if (itemStack.func_77973_b() instanceof IEnergyItem) {
            int floor = (int)Math.floor(joules);
            return ((IEnergyItem)itemStack.func_77973_b()).discharge(itemStack, floor, doDischarge);
        }
        if (itemStack.func_77973_b() instanceof IEnergyBufferItem) {
            int e = ((IEnergyBufferItem)itemStack.func_77973_b()).getEnergyCapacity(itemStack);
            if (joules >= (double)e) {
                if (doDischarge) {
                    ((IEnergyBufferItem)itemStack.func_77973_b()).setEnergy(itemStack, 0);
                }
                return e;
            }
            int newEnergy = (int)Math.floor((double)e - joules);
            int removed = e - newEnergy;
            if (doDischarge) {
                ((IEnergyBufferItem)itemStack.func_77973_b()).setEnergy(itemStack, newEnergy);
            }
            return removed;
        }
        return 0.0;
    }

    @Override
    public boolean doIsHandler(Object obj, ForgeDirection dir) {
        return this.doIsHandler(obj);
    }

    @Override
    public boolean doIsHandler(Object obj) {
        if (obj instanceof ItemStack) {
            Item item = ((ItemStack)obj).func_77973_b();
            return this.doIsHandler(item);
        }
        if (obj instanceof Item) {
            return obj instanceof IEnergyItem || obj instanceof IEnergyBufferItem;
        }
        return obj instanceof IEnergyBufferProvider;
    }

    @Override
    public boolean doIsEnergyContainer(Object obj) {
        if (obj instanceof ItemStack) {
            Item item = ((ItemStack)obj).func_77973_b();
            return this.doIsHandler(item);
        }
        if (obj instanceof Item) {
            return obj instanceof IEnergyBufferItem;
        }
        return obj instanceof IEnergyBufferProvider;
    }

    @Override
    public boolean canConnect(Object obj, ForgeDirection direction, Object source) {
        if (obj instanceof ITileConnection) {
            return ((ITileConnection)obj).canConnect(source instanceof TileEntity ? (TileEntity)source : (TileEntity)null, ConnectionType.POWER, direction);
        }
        return true;
    }

    @Override
    public ItemStack getItemWithCharge(ItemStack itemStack, double energy) {
        if (itemStack.func_77973_b() instanceof IEnergyItem) {
            ((IEnergyItem)itemStack.func_77973_b()).recharge(itemStack, (int)Math.floor(energy), true);
        }
        return itemStack;
    }

    @Override
    public double getEnergy(Object obj, ForgeDirection direction) {
        IEnergyBuffer buffer;
        if (obj instanceof ItemStack && ((ItemStack)obj).func_77973_b() instanceof IEnergyBufferItem) {
            return ((IEnergyBufferItem)((ItemStack)obj).func_77973_b()).getEnergy((ItemStack)obj);
        }
        if (obj instanceof IEnergyBufferProvider && (buffer = ((IEnergyBufferProvider)obj).getEnergyBuffer(direction)) != null) {
            return buffer.getEnergyStored();
        }
        return 0.0;
    }

    @Override
    public double getMaxEnergy(Object obj, ForgeDirection direction) {
        IEnergyBuffer buffer;
        if (obj instanceof ItemStack && ((ItemStack)obj).func_77973_b() instanceof IEnergyBufferItem) {
            return ((IEnergyBufferItem)((ItemStack)obj).func_77973_b()).getEnergyCapacity((ItemStack)obj);
        }
        if (obj instanceof IEnergyBufferProvider && (buffer = ((IEnergyBufferProvider)obj).getEnergyBuffer(direction)) != null) {
            return buffer.getMaxBufferSize();
        }
        return 0.0;
    }

    @Override
    public double getEnergyItem(ItemStack is) {
        return this.getEnergy(is, null);
    }

    @Override
    public double getMaxEnergyItem(ItemStack is) {
        return this.getMaxEnergy(is, null);
    }

    @Override
    public double clearEnergy(Object obj, boolean doAction) {
        IEnergyBuffer buffer;
        if (obj instanceof ItemStack && ((ItemStack)obj).func_77973_b() instanceof IEnergyBufferItem) {
            double e = ((IEnergyBufferItem)((ItemStack)obj).func_77973_b()).getEnergy((ItemStack)obj);
            ((IEnergyBufferItem)((ItemStack)obj).func_77973_b()).setEnergy((ItemStack)obj, 0);
            return e;
        }
        if (obj instanceof IEnergyBufferProvider && (buffer = ((IEnergyBufferProvider)obj).getEnergyBuffer(ForgeDirection.UNKNOWN)) != null) {
            double e = buffer.getEnergyStored();
            buffer.setEnergyStored(0);
            return e;
        }
        return 0.0;
    }

    @Override
    public double setFullCharge(Object handler) {
        if (handler instanceof IEnergyBufferProvider) {
            IEnergyBuffer buffer = ((IEnergyBufferProvider)handler).getEnergyBuffer(ForgeDirection.UNKNOWN);
            if (buffer != null) {
                int energy = buffer.getEnergyStored();
                buffer.setEnergyStored(buffer.getMaxBufferSize());
                return buffer.getEnergyStored() - energy;
            }
        } else if (handler instanceof ItemStack && ((ItemStack)handler).func_77973_b() instanceof IEnergyBufferItem) {
            int energy = ((IEnergyBufferItem)((ItemStack)handler).func_77973_b()).getEnergy((ItemStack)handler);
            int cap = ((IEnergyBufferItem)((ItemStack)handler).func_77973_b()).getEnergyCapacity((ItemStack)handler);
            ((IEnergyBufferItem)((ItemStack)handler).func_77973_b()).setEnergy((ItemStack)handler, cap);
            return cap - energy;
        }
        return this.receiveEnergy(handler, ForgeDirection.UNKNOWN, Double.MAX_VALUE, true);
    }
}

