/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.explosive.blast;

import com.builtbroken.jlib.data.network.IByteBufReader;
import com.builtbroken.jlib.data.network.IByteBufWriter;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.api.abstraction.world.IWorld;
import com.builtbroken.mc.api.edit.IWorldChangeAction;
import com.builtbroken.mc.api.edit.IWorldChangeAudio;
import com.builtbroken.mc.api.edit.IWorldChangeGraphics;
import com.builtbroken.mc.api.edit.IWorldEdit;
import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.event.blast.BlastEventBlockEdit;
import com.builtbroken.mc.api.event.blast.BlastEventBlockRemoved;
import com.builtbroken.mc.api.event.blast.BlastEventBlockReplaced;
import com.builtbroken.mc.api.explosive.IBlast;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.framework.explosive.blast.PostBlastTrigger;
import com.builtbroken.mc.imp.transform.vector.Location;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.world.edit.BlockEdit;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.WorldEvent;

public abstract class Blast<B extends Blast>
implements IWorldChangeAction,
IWorldPosition,
IWorldChangeAudio,
IWorldChangeGraphics,
IBlast,
IByteBufReader,
IByteBufWriter {
    @Deprecated
    public World oldWorld;
    public IWorld world;
    public double x;
    public double y;
    public double z;
    public Location blockCenter;
    public double size = 1.0;
    public float eUnitPerBlock = 5.0f;
    public boolean killExplosion = false;
    public TriggerCause cause = new TriggerCause.TriggerCauseRedstone(ForgeDirection.UNKNOWN, 15);
    private NBTTagCompound additionBlastData;
    public final IExplosiveHandler explosiveHandler;
    public Entity explosionBlameEntity;
    public Explosion wrapperExplosion;
    public List<PostBlastTrigger> explosivesToTriggerAfter = new ArrayList<PostBlastTrigger>();

    public Blast(IExplosiveHandler handler) {
        this.explosiveHandler = handler;
        this.wrapperExplosion = new WrapperExplosion(this);
        if (!Engine.isJUnitTest()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public Blast(IExplosiveHandler handler, World world, int x, int y, int z, int size) {
        this(handler);
        this.setLocation(world, x, y, z);
        this.setYield(size);
    }

    public PostBlastTrigger addPostTriggerExplosive(String explosiveID, double size, TriggerCause triggerCause, NBTTagCompound data) {
        IExplosiveHandler handler = ExplosiveRegistry.get(explosiveID);
        if (handler != null) {
            PostBlastTrigger blastTrigger = new PostBlastTrigger(handler, size, triggerCause, data);
            this.explosivesToTriggerAfter.add(blastTrigger);
            return blastTrigger;
        }
        return null;
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        if (event.world == this.oldWorld) {
            this.killAction(false);
            MinecraftForge.EVENT_BUS.unregister((Object)this);
        }
    }

    public B setLocation(World world, double x, double y, double z) {
        if (world != null) {
            this.oldWorld = world;
            this.world = Engine.getWorld(this.oldWorld.field_73011_w.field_76574_g);
        }
        this.x = x;
        this.y = y;
        this.z = z;
        this.blockCenter = new Location(world, Math.floor(x) + 0.5, Math.floor(y) + 0.5, Math.floor(z) + 0.5);
        return (B)this;
    }

    public B setYield(double size) {
        this.size = size;
        return (B)this;
    }

    @Override
    public double getYield() {
        return this.size;
    }

    public B setEnergyPerBlock(float f) {
        this.eUnitPerBlock = f;
        return (B)this;
    }

    public B setCause(TriggerCause cause) {
        this.cause = cause;
        if (cause != null) {
            if (cause instanceof TriggerCause.TriggerCauseEntity) {
                this.explosionBlameEntity = ((TriggerCause.TriggerCauseEntity)cause).source;
            }
            if (this.explosionBlameEntity == null) {
                this.explosionBlameEntity = new EntityTNTPrimed(this.oldWorld);
                this.explosionBlameEntity.func_70107_b(this.x, this.y, this.z);
            }
        }
        return (B)this;
    }

    public B setAdditionBlastData(NBTTagCompound additionBlastData) {
        this.additionBlastData = additionBlastData;
        return (B)this;
    }

    public NBTTagCompound getAdditionBlastData() {
        return this.additionBlastData;
    }

    @Override
    public int shouldThreadAction() {
        return this.size > 4.0 ? -2 : -1;
    }

    public List<IWorldEdit> getEffectedBlocks() {
        ArrayList<IWorldEdit> list = new ArrayList<IWorldEdit>();
        this.getEffectedBlocks(list);
        return list;
    }

    public void getEffectedBlocks(List<IWorldEdit> list) {
    }

    @Override
    public void handleBlockPlacement(IWorldEdit vec) {
        if (vec != null && vec.hasChanged() && this.prePlace(vec)) {
            vec.place();
            this.postPlace(vec);
        }
    }

    protected void postPlace(IWorldEdit vec) {
        if (vec.getNewBlock() == Blocks.field_150350_a) {
            MinecraftForge.EVENT_BUS.post((Event)new BlastEventBlockRemoved.Post(this, this.oldWorld, vec.getBlock(), vec.getBlockMetadata(), (int)vec.x(), (int)vec.y(), (int)vec.z()));
        } else {
            MinecraftForge.EVENT_BUS.post((Event)new BlastEventBlockReplaced.Post(this, this.oldWorld, vec.getBlock(), vec.getBlockMetadata(), vec.getNewBlock(), vec.getNewMeta(), (int)vec.x(), (int)vec.y(), (int)vec.z()));
        }
    }

    protected boolean prePlace(IWorldEdit vec) {
        BlastEventBlockEdit event = vec.getNewBlock() == Blocks.field_150350_a ? new BlastEventBlockRemoved.Pre(this, this.oldWorld, vec.getBlock(), vec.getBlockMetadata(), (int)vec.x(), (int)vec.y(), (int)vec.z()) : new BlastEventBlockReplaced.Pre(this, this.oldWorld, vec.getBlock(), vec.getBlockMetadata(), vec.getNewBlock(), vec.getNewMeta(), (int)vec.x(), (int)vec.y(), (int)vec.z());
        boolean result = MinecraftForge.EVENT_BUS.post((Event)event);
        if (vec instanceof BlockEdit && event instanceof BlastEventBlockReplaced.Pre) {
            ((BlockEdit)vec).set(((BlastEventBlockReplaced.Pre)event).newBlock, ((BlastEventBlockReplaced.Pre)event).newMeta);
        }
        return !result;
    }

    protected int getFortuneModifierForBlockDrop() {
        return 0;
    }

    @Override
    public void doEffectOther(boolean beforeBlocksPlaced) {
        if (!beforeBlocksPlaced) {
            for (PostBlastTrigger handler : this.explosivesToTriggerAfter) {
                if (handler == null) continue;
                handler.triggerExplosive(this.toLocation());
            }
        }
    }

    protected void damageEntities(List<Entity> entities, DamageSource source) {
        this.damageEntities(entities, source, 1.0f);
    }

    protected void damageEntities(List<Entity> entities, DamageSource source, float damageScale) {
        Vec3 vec3 = Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
        for (Entity entity : entities) {
            double deltaZ;
            double deltaY;
            double deltaX;
            double mag;
            double distanceScaled = entity.func_70011_f(this.x, this.y, this.z) / this.size;
            if (!(distanceScaled <= 1.0) || (mag = (double)MathHelper.func_76133_a((double)((deltaX = entity.field_70165_t - this.x) * deltaX + (deltaY = entity.field_70163_u + (double)entity.func_70047_e() - this.y) * deltaY + (deltaZ = entity.field_70161_v - this.z) * deltaZ))) == 0.0) continue;
            deltaX /= mag;
            deltaY /= mag;
            deltaZ /= mag;
            double blockDensity = this.oldWorld.func_72842_a(vec3, entity.field_70121_D);
            double force = (1.0 - distanceScaled) * blockDensity;
            if (source != null) {
                entity.func_70097_a(source, (float)((force * force + force) / 16.0 * this.size * (double)damageScale + 1.0));
            }
            double pushPercentage = EnchantmentProtection.func_92092_a((Entity)entity, (double)force);
            entity.field_70159_w += deltaX * pushPercentage;
            entity.field_70181_x += deltaY * pushPercentage;
            entity.field_70179_y += deltaZ * pushPercentage;
        }
    }

    @Override
    public void killAction(boolean willSave) {
        this.killExplosion = true;
    }

    protected boolean shouldKillAction() {
        return this.killExplosion || this.oldWorld == null || this.oldWorld.field_73011_w == null || DimensionManager.getWorld((int)this.oldWorld.field_73011_w.field_76574_g) == null || !this.toLocation().isChunkLoaded();
    }

    @Override
    public World oldWorld() {
        return this.oldWorld;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double z() {
        return this.z;
    }

    @Override
    public void playAudioForEdit(IWorldEdit blocks) {
    }

    @Override
    public void doStartAudio() {
        if (!this.oldWorld.field_72995_K) {
            this.oldWorld.func_72908_a(this.x, this.y, this.z, "random.explode", 4.0f, (float)((double)(1.0f + (this.oldWorld.field_73012_v.nextFloat() - this.oldWorld.field_73012_v.nextFloat()) * 0.2f) * this.size));
        }
    }

    @Override
    public void doEndAudio() {
    }

    @Override
    public void displayEffectForEdit(IWorldEdit blocks) {
        if (!this.oldWorld.field_72995_K) {
            double posX = (float)blocks.x() + this.oldWorld.field_73012_v.nextFloat();
            double posY = (float)blocks.y() + this.oldWorld.field_73012_v.nextFloat();
            double posZ = (float)blocks.z() + this.oldWorld.field_73012_v.nextFloat();
            Pos pos = this.randomMotion(posX, posY, posZ);
            this.oldWorld.func_72869_a("explode", (posX + this.x * 1.0) / 2.0, (posY + this.y * 1.0) / 2.0, (posZ + this.z * 1.0) / 2.0, pos.x(), pos.y(), pos.z());
            this.oldWorld.func_72869_a("smoke", posX, posY, posZ, pos.x(), pos.y(), pos.z());
        }
    }

    protected final Pos randomMotion(double posX, double posY, double posZ) {
        double deltaX = posX - this.x;
        double deltaY = posY - this.y;
        double deltaZ = posZ - this.z;
        double mag = MathHelper.func_76133_a((double)(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ));
        deltaX /= mag;
        deltaY /= mag;
        deltaZ /= mag;
        double speedScale = 0.5 / (mag / this.size + 0.1);
        return new Pos(deltaX *= (speedScale *= (double)(this.oldWorld.field_73012_v.nextFloat() * this.oldWorld.field_73012_v.nextFloat() + 0.3f)), deltaY *= speedScale, deltaZ *= speedScale);
    }

    @Override
    public void doStartDisplay() {
        if (!this.oldWorld.field_72995_K) {
            if (this.size >= 2.0) {
                this.world.spawnParticle("hugeexplosion", this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.world.spawnParticle("largeexplode", this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void doEndDisplay() {
        if (this.oldWorld.field_72995_K) {
            if (this.size >= 2.0) {
                this.world.spawnParticle("hugeexplosion", this.x, this.y, this.z, 1.0, 0.0, 0.0);
            } else {
                this.world.spawnParticle("largeexplode", this.x, this.y, this.z, 1.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public boolean isCompleted() {
        return this.oldWorld == null || this.killExplosion;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj.getClass() == this.getClass() && obj instanceof Blast) {
            if (((Blast)obj).oldWorld != this.oldWorld) {
                return false;
            }
            if (((Blast)obj).x != this.x) {
                return false;
            }
            if (((Blast)obj).y != this.y) {
                return false;
            }
            if (((Blast)obj).z != this.z) {
                return false;
            }
            return ((Blast)obj).size == this.size;
        }
        return false;
    }

    public B readBytes(ByteBuf buf) {
        return (B)this;
    }

    public ByteBuf writeBytes(ByteBuf buf) {
        return buf;
    }

    public static class WrapperExplosion
    extends Explosion {
        public final Blast blast;

        public WrapperExplosion(Blast blast) {
            super(blast.oldWorld(), blast.explosionBlameEntity, blast.x(), blast.y(), blast.z(), (float)blast.size);
            this.blast = blast;
        }
    }
}

