/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.explosive.blast;

import com.builtbroken.mc.api.event.TriggerCause;
import com.builtbroken.mc.api.explosive.IExplosiveHandler;
import com.builtbroken.mc.framework.explosive.ExplosiveRegistry;
import com.builtbroken.mc.imp.transform.vector.Location;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;

public class PostBlastTrigger {
    public final IExplosiveHandler handler;
    public final NBTTagCompound data;
    public final TriggerCause cause;
    public final double size;
    public final List<PostBlastTrigger> postsToAdd = new ArrayList<PostBlastTrigger>();

    public PostBlastTrigger(IExplosiveHandler handler, double size, TriggerCause triggerCause, NBTTagCompound data) {
        this.handler = handler;
        this.cause = triggerCause;
        this.data = data;
        this.size = size;
    }

    public void triggerExplosive(Location location) {
        ExplosiveRegistry.triggerExplosive(location, this.handler, this.cause, this.size, this.data);
    }

    public PostBlastTrigger addPostTriggerExplosive(String explosiveID, double v, TriggerCause triggerCause, NBTTagCompound tagCompound) {
        IExplosiveHandler handler = ExplosiveRegistry.get(explosiveID);
        if (handler != null) {
            PostBlastTrigger blastTrigger = new PostBlastTrigger(handler, this.size, triggerCause, this.data);
            this.postsToAdd.add(blastTrigger);
            return blastTrigger;
        }
        return null;
    }
}

