/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.conversion.structures.arrays;

import com.builtbroken.mc.framework.json.conversion.JsonConverter;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;

public class JsonConverterShortArray
extends JsonConverter<short[]> {
    public JsonConverterShortArray() {
        super("array.short", new String[0]);
    }

    @Override
    public short[] convert(JsonElement element, String ... args) {
        if (element instanceof JsonArray) {
            short[] array = new short[element.getAsJsonArray().size()];
            int index = 0;
            for (JsonElement e : element.getAsJsonArray()) {
                if (e.isJsonPrimitive() && e.getAsJsonPrimitive().isNumber()) {
                    int n = index;
                    index = (short)(index + 1);
                    array[n] = e.getAsShort();
                    continue;
                }
                throw new IllegalArgumentException("Can not convert object to short array, as '" + e + "' is not an short");
            }
            return array;
        }
        return null;
    }
}

