/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.conversion.structures.map;

import com.builtbroken.mc.framework.json.conversion.JsonConverter;
import com.builtbroken.mc.framework.json.processors.JsonProcessor;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;

public class JsonConverterHashMap
extends JsonConverter<HashMap> {
    public JsonConverterHashMap() {
        super("HashMap", new String[0]);
    }

    @Override
    public HashMap convert(JsonElement element, String[] args) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (args.length != 4) {
            throw new RuntimeException("JsonConverterHashMap: argument length should be 4 (key, type, value, type) for converting an entry to a hash map");
        }
        if (element.isJsonArray()) {
            String key = args[0];
            String keyType = args[1];
            String value = args[2];
            String valueType = args[3];
            for (JsonElement e : element.getAsJsonArray()) {
                if (e.isJsonObject()) {
                    JsonObject object = e.getAsJsonObject();
                    JsonProcessor.ensureValuesExist(object, key, value);
                    JsonElement keyData = object.get(key);
                    JsonElement valueData = object.get(value);
                    Object keyObject = JsonConverterHashMap.convertElement(keyType, keyData, new String[0]);
                    Object valueObject = JsonConverterHashMap.convertElement(valueType, valueData, new String[0]);
                    if (keyObject == null) {
                        throw new RuntimeException("JsonConverterHashMap: failed to convert key data '" + keyData + "' to type '" + keyType + "'");
                    }
                    if (valueObject == null) {
                        throw new RuntimeException("JsonConverterHashMap: failed to convert value data '" + valueData + "' to type '" + valueType + "'");
                    }
                    map.put(keyObject, valueObject);
                    continue;
                }
                throw new RuntimeException("JsonConverterHashMap: entries in json array must be json objects, example: map:[{o1}, {o2}, {o3}]");
            }
        } else {
            throw new RuntimeException("JsonConverterHashMap: json element needs to be an array in order to convert to hash map");
        }
        return map;
    }
}

