/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.json.loading;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.json.JsonContentLoader;
import com.builtbroken.mc.framework.json.conversion.JsonConverter;
import com.builtbroken.mc.framework.json.conversion.data.energy.JsonConverterEnergyBufferData;
import com.builtbroken.mc.framework.json.conversion.data.energy.JsonConverterEnergyChargeData;
import com.builtbroken.mc.framework.json.conversion.data.mc.JsonConverterBlock;
import com.builtbroken.mc.framework.json.conversion.data.mc.JsonConverterItem;
import com.builtbroken.mc.framework.json.conversion.data.mc.JsonConverterMaterial;
import com.builtbroken.mc.framework.json.conversion.data.mc.JsonConverterNBT;
import com.builtbroken.mc.framework.json.conversion.data.transform.JsonConverterCube;
import com.builtbroken.mc.framework.json.conversion.data.transform.JsonConverterPos;
import com.builtbroken.mc.framework.json.conversion.primitives.JsonConverterByte;
import com.builtbroken.mc.framework.json.conversion.primitives.JsonConverterDouble;
import com.builtbroken.mc.framework.json.conversion.primitives.JsonConverterFloat;
import com.builtbroken.mc.framework.json.conversion.primitives.JsonConverterInt;
import com.builtbroken.mc.framework.json.conversion.primitives.JsonConverterLong;
import com.builtbroken.mc.framework.json.conversion.primitives.JsonConverterShort;
import com.builtbroken.mc.framework.json.conversion.primitives.JsonConverterString;
import com.builtbroken.mc.framework.json.conversion.structures.arrays.JsonConverterByteArray;
import com.builtbroken.mc.framework.json.conversion.structures.arrays.JsonConverterIntegerArray;
import com.builtbroken.mc.framework.json.conversion.structures.arrays.JsonConverterShortArray;
import com.builtbroken.mc.framework.json.conversion.structures.arrays.JsonConverterStringArray;
import com.builtbroken.mc.framework.json.conversion.structures.list.JsonConverterList;
import com.builtbroken.mc.framework.json.conversion.structures.map.JsonConverterHashMap;
import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.framework.json.loading.JsonEntry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonLoader {
    private static final HashMap<String, JsonConverter> conversionHandlers = new HashMap();

    public static void addConverter(JsonConverter converter) {
        List<String> keys = converter.keys;
        for (String key : keys) {
            if (JsonLoader.getConversionHandlers().containsKey(key)) {
                Engine.logger().error("Overriding converter '" + key + "' with " + converter + ", previous value " + JsonLoader.getConversionHandlers().get(key));
            }
            JsonLoader.getConversionHandlers().put(key.toLowerCase(), converter);
        }
    }

    public static Object convertElement(String type, JsonElement data, String ... args) {
        ArrayList<IJsonGenObject> objects;
        JsonConverter converter = JsonLoader.getConversionHandler(type);
        if (converter != null) {
            return converter.convert(data, args);
        }
        IJsonProcessor processor = JsonContentLoader.INSTANCE.get(type);
        if (processor != null && processor.canProcess(type, data) && processor.process(data, objects = new ArrayList<IJsonGenObject>())) {
            if (objects.size() == 1) {
                return objects.get(0);
            }
            if (objects.size() > 1) {
                return objects;
            }
        }
        return null;
    }

    public static void loadJsonFileFromResources(URL resource, HashMap<String, List<JsonEntry>> entries) throws Exception {
        if (resource != null) {
            JsonLoader.loadJson(resource.getFile(), new InputStreamReader(resource.openStream()), entries);
        }
    }

    public static void loadJsonFile(File file, HashMap<String, List<JsonEntry>> entries) throws IOException {
        if (file.exists() && file.isFile()) {
            FileReader stream = new FileReader(file);
            JsonLoader.loadJson(file.getName(), new BufferedReader(stream), entries);
            stream.close();
        }
    }

    public static void loadJson(String fileName, Reader reader, HashMap<String, List<JsonEntry>> entries) {
        try {
            JsonReader jsonReader = new JsonReader(reader);
            JsonElement element = Streams.parse((JsonReader)jsonReader);
            JsonLoader.loadJsonElement(fileName, element, entries);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse file '" + fileName + "'", e);
        }
    }

    public static JsonElement createElement(String data) {
        JsonReader jsonReader = new JsonReader((Reader)new StringReader(data));
        return Streams.parse((JsonReader)jsonReader);
    }

    public static List<JsonEntry> loadJsonElement(String file, JsonElement element, HashMap<String, List<JsonEntry>> entries) {
        if (element.isJsonObject()) {
            JsonObject object = element.getAsJsonObject();
            if (object.has("loadCondition")) {
                String condition = object.getAsJsonPrimitive("loadCondition").getAsString();
                if (condition.equalsIgnoreCase("devMode") && !Engine.runningAsDev) {
                    return new ArrayList<JsonEntry>();
                }
                if (condition.startsWith("mod:")) {
                    String modName = condition.substring(4, condition.length());
                    List mods = Loader.instance().getActiveModList();
                    boolean found = false;
                    for (ModContainer mod : mods) {
                        if (!mod.getModId().equalsIgnoreCase(modName)) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        Engine.logger().info("JsonLoader: File '" + file + "' contains load condition for mod '" + modName + "' but mod is not loaded. This file will be ignored for JSON loading.");
                        return new ArrayList<JsonEntry>();
                    }
                }
            }
            String author = null;
            String helpSite = null;
            if (object.has("author")) {
                JsonObject authorData = object.get("author").getAsJsonObject();
                author = authorData.get("name").getAsString();
                if (authorData.has("site")) {
                    helpSite = authorData.get("site").getAsString();
                }
            }
            ArrayList<JsonEntry> processedEntries = new ArrayList<JsonEntry>();
            for (Map.Entry entry : object.entrySet()) {
                if (JsonLoader.ignoreLoadingEntry((String)entry.getKey())) continue;
                String key = (String)entry.getKey();
                if (key.contains(":")) {
                    key = key.split(":")[0];
                }
                JsonEntry jsonEntry = new JsonEntry(key, file, (JsonElement)entry.getValue());
                jsonEntry.author = author;
                jsonEntry.authorHelpSite = helpSite;
                List<JsonEntry> list = entries.get(jsonEntry.jsonKey);
                if (list == null) {
                    list = new ArrayList<JsonEntry>();
                }
                list.add(jsonEntry);
                entries.put(jsonEntry.jsonKey, list);
                processedEntries.add(jsonEntry);
            }
            return processedEntries;
        }
        return null;
    }

    private static boolean ignoreLoadingEntry(String key) {
        return key.equalsIgnoreCase("author") || key.startsWith("_") || key.equalsIgnoreCase("loadCondition") || key.equalsIgnoreCase("editorData");
    }

    public static HashMap<String, JsonConverter> getConversionHandlers() {
        return conversionHandlers;
    }

    public static JsonConverter getConversionHandler(String key) {
        return conversionHandlers.get(key.toLowerCase());
    }

    public static boolean hasConverterFor(String key) {
        return JsonLoader.getConversionHandler(key) != null;
    }

    static {
        JsonLoader.addConverter(new JsonConverterPos());
        JsonLoader.addConverter(new JsonConverterCube());
        JsonLoader.addConverter(new JsonConverterItem());
        JsonLoader.addConverter(new JsonConverterBlock());
        JsonLoader.addConverter(new JsonConverterNBT());
        JsonLoader.addConverter(new JsonConverterMaterial());
        JsonLoader.addConverter(new JsonConverterEnergyBufferData());
        JsonLoader.addConverter(new JsonConverterEnergyChargeData());
        JsonLoader.addConverter(new JsonConverterStringArray());
        JsonLoader.addConverter(new JsonConverterIntegerArray());
        JsonLoader.addConverter(new JsonConverterShortArray());
        JsonLoader.addConverter(new JsonConverterByteArray());
        JsonLoader.addConverter(new JsonConverterHashMap());
        JsonLoader.addConverter(new JsonConverterList());
        JsonLoader.addConverter(new JsonConverterString());
        JsonLoader.addConverter(new JsonConverterByte());
        JsonLoader.addConverter(new JsonConverterShort());
        JsonLoader.addConverter(new JsonConverterInt());
        JsonLoader.addConverter(new JsonConverterLong());
        JsonLoader.addConverter(new JsonConverterFloat());
        JsonLoader.addConverter(new JsonConverterDouble());
    }
}

