/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.framework.recipe.cast;

import com.builtbroken.mc.api.items.crafting.ICastItem;
import com.builtbroken.mc.api.recipe.ICastingRecipe;
import com.builtbroken.mc.api.recipe.IMachineRecipe;
import com.builtbroken.mc.api.recipe.IMachineRecipeHandler;
import com.builtbroken.mc.api.recipe.MachineRecipeType;
import com.builtbroken.mc.api.recipe.RecipeRegisterResult;
import com.builtbroken.mc.core.References;
import com.builtbroken.mc.lib.data.item.ItemStackWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class MRHandlerCast
implements IMachineRecipeHandler<ItemStack, ICastingRecipe> {
    public Map<String, HashMap<Fluid, List<ICastingRecipe>>> cast_map = new HashMap<String, HashMap<Fluid, List<ICastingRecipe>>>();
    public Map<String, Integer> cast_volume_map = new HashMap<String, Integer>();
    public Map<ItemStackWrapper, String> castToTypeMap = new HashMap<ItemStackWrapper, String>();
    public static MRHandlerCast INSTANCE = new MRHandlerCast();

    @Override
    public RecipeRegisterResult registerRecipe(ICastingRecipe recipe) {
        RecipeRegisterResult result = this.isValidRecipe(recipe);
        if (result == RecipeRegisterResult.REGISTERED) {
            if (!this.cast_map.containsKey(recipe.getCastType())) {
                this.cast_map.put(recipe.getCastType(), new HashMap());
            }
            for (FluidStack fluidStack : recipe.getValidInputs()) {
                if (!this.cast_map.get(recipe.getCastType()).containsKey(fluidStack.getFluid())) {
                    this.cast_map.get(recipe.getCastType()).put(fluidStack.getFluid(), new ArrayList());
                }
                this.cast_map.get(recipe.getCastType()).get(fluidStack.getFluid()).add(recipe);
            }
        }
        return result;
    }

    public RecipeRegisterResult addType(String type, int volume) {
        if (!this.cast_volume_map.containsKey(type)) {
            this.cast_volume_map.put(type, volume);
        }
        return RecipeRegisterResult.ALREADY_EXISTS;
    }

    public RecipeRegisterResult registerCast(ItemStack stack) {
        ItemStackWrapper wrap = new ItemStackWrapper(stack);
        if (!this.castToTypeMap.containsKey(wrap)) {
            if (stack.func_77973_b() instanceof ICastItem) {
                this.castToTypeMap.put(wrap, ((ICastItem)stack.func_77973_b()).getCastType(stack));
                return RecipeRegisterResult.REGISTERED;
            }
            return RecipeRegisterResult.INVALID_TYPE;
        }
        return RecipeRegisterResult.ALREADY_EXISTS;
    }

    public int getVolumeForCast(String type) {
        return this.cast_volume_map.containsKey(type) ? this.cast_volume_map.get(type) : References.INGOT_VOLUME;
    }

    protected RecipeRegisterResult isValidRecipe(ICastingRecipe recipe) {
        if (recipe != null) {
            if (recipe.getType() != MachineRecipeType.FLUID_CAST.name()) {
                return RecipeRegisterResult.INVALID_TYPE;
            }
            if (recipe.getValidInputs() != null && recipe.getOutput() != null) {
                if (!(recipe.getOutput() instanceof ItemStack)) {
                    return RecipeRegisterResult.INVALID_OUTPUT;
                }
                for (Object object : recipe.getValidInputs()) {
                    if (object instanceof Fluid || object instanceof FluidStack) continue;
                    return RecipeRegisterResult.INVALID_INPUT;
                }
                return RecipeRegisterResult.REGISTERED;
            }
        }
        return RecipeRegisterResult.FAILED;
    }

    @Override
    public ItemStack getRecipe(Object[] items, float extraChance, float failureChance) {
        if (items != null) {
            for (IMachineRecipe iMachineRecipe : this.getRecipes(items)) {
                Object result;
                if (!iMachineRecipe.shouldHandleRecipe(items) || !((result = iMachineRecipe.handleRecipe(items, extraChance, failureChance)) instanceof ItemStack)) continue;
                return (ItemStack)result;
            }
        }
        return null;
    }

    @Override
    public final Collection<ICastingRecipe> getRecipes(Object[] items) {
        ItemStackWrapper stack;
        if (items != null && items.length > 0 && items[0] instanceof ItemStack && ((ItemStack)items[0]).func_77973_b() instanceof ICastItem && this.castToTypeMap.containsKey(stack = new ItemStackWrapper((ItemStack)items[0]))) {
            String type = this.castToTypeMap.get(stack);
            if (this.cast_map.containsKey(type)) {
                HashMap<Fluid, List<ICastingRecipe>> map = this.cast_map.get(type);
                if (items.length == 1) {
                    ArrayList<ICastingRecipe> recipes = new ArrayList<ICastingRecipe>();
                    for (List<ICastingRecipe> l : map.values()) {
                        recipes.addAll(l);
                    }
                    return recipes;
                }
                if (items.length == 2) {
                    if (items[1] instanceof Fluid && map.containsKey(items[1])) {
                        return map.get(items[1]);
                    }
                    if (items[1] instanceof FluidStack && map.containsKey(((FluidStack)items[1]).getFluid())) {
                        return map.get(((FluidStack)items[1]).getFluid());
                    }
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public List<ICastingRecipe> getRecipes() {
        ArrayList<ICastingRecipe> list = new ArrayList<ICastingRecipe>();
        for (HashMap<Fluid, List<ICastingRecipe>> map : this.cast_map.values()) {
            for (List<ICastingRecipe> l : map.values()) {
                list.addAll(l);
            }
        }
        return list;
    }
}

