/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.imp.transform.vector;

import com.builtbroken.jlib.data.vector.IPos3D;
import com.builtbroken.mc.api.IWorldPosition;
import com.builtbroken.mc.imp.transform.vector.AbstractPos;
import com.builtbroken.mc.imp.transform.vector.Pos;
import io.netty.buffer.ByteBuf;
import net.minecraft.block.Block;
import net.minecraft.dispenser.ILocation;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.DimensionManager;

public abstract class AbstractLocation<R extends AbstractLocation>
extends AbstractPos<R>
implements ILocation {
    public World world;

    public AbstractLocation(World world, double x, double y, double z) {
        super(x, y, z);
        this.world = world;
    }

    public AbstractLocation(NBTTagCompound nbt) {
        this((World)DimensionManager.getWorld((int)nbt.func_74762_e("dimension")), nbt.func_74769_h("x"), nbt.func_74769_h("y"), nbt.func_74769_h("z"));
    }

    public AbstractLocation(ByteBuf data) {
        this((World)DimensionManager.getWorld((int)data.readInt()), data.readDouble(), data.readDouble(), data.readDouble());
    }

    public AbstractLocation(Entity entity) {
        this(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
    }

    public AbstractLocation(TileEntity tile) {
        this(tile.func_145831_w(), tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
    }

    public AbstractLocation(IWorldPosition vec) {
        this(vec.oldWorld(), vec.x(), vec.y(), vec.z());
    }

    public AbstractLocation(World world, IPos3D vector) {
        this(world, vector.x(), vector.y(), vector.z());
    }

    public AbstractLocation(World world, Vec3 vec) {
        this(world, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c);
    }

    public AbstractLocation(World world, MovingObjectPosition target) {
        this(world, target.field_72307_f);
    }

    public World oldWorld() {
        return this.world;
    }

    public World func_82618_k() {
        return this.world;
    }

    @Override
    public NBTTagCompound writeNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("dimension", this.world != null && this.world.field_73011_w != null ? this.world.field_73011_w.field_76574_g : 0);
        nbt.func_74780_a("x", this.x());
        nbt.func_74780_a("y", this.y());
        nbt.func_74780_a("z", this.z());
        return nbt;
    }

    @Override
    public ByteBuf writeByteBuf(ByteBuf data) {
        data.writeInt(this.world != null && this.world.field_73011_w != null ? this.world.field_73011_w.field_76574_g : 0);
        data.writeDouble(this.x());
        data.writeDouble(this.y());
        data.writeDouble(this.z());
        return data;
    }

    @Deprecated
    public Pos toVector3() {
        return new Pos(this.x(), this.y(), this.z());
    }

    public Pos toPos() {
        return new Pos(this.x(), this.y(), this.z());
    }

    public Block getBlock() {
        if (this.world != null && this.world.func_72863_F().func_73149_a(this.xi() / 16, this.zi() / 16)) {
            return super.getBlock((IBlockAccess)this.world);
        }
        return null;
    }

    public int getBlockMetadata() {
        if (this.world != null) {
            return super.getBlockMetadata((IBlockAccess)this.world);
        }
        return -1;
    }

    public TileEntity getTileEntity() {
        if (this.world != null) {
            TileEntity tile = this.world.func_147438_o(this.xi(), this.yi(), this.zi());
            return tile == null || tile.func_145837_r() ? null : tile;
        }
        return null;
    }

    public float getHardness() {
        return super.getHardness(this.world);
    }

    public float getResistance(Entity cause, double xx, double yy, double zz) {
        return this.getBlock((IBlockAccess)this.world).getExplosionResistance(cause, this.world, this.xi(), this.yi(), this.zi(), xx, yy, zz);
    }

    public BiomeGenBase getBiomeGen() {
        return this.oldWorld().func_72807_a(this.xi(), this.zi());
    }

    public boolean setBlock(Block block, int metadata, int notify) {
        return super.setBlock(this.world, block, metadata, notify);
    }

    public boolean setBlock(Block block, int metadata) {
        return super.setBlock(this.world, block, metadata);
    }

    public boolean setBlock(Block block) {
        return super.setBlock(this.world, block);
    }

    public boolean setBlockToAir() {
        return super.setBlockToAir(this.world);
    }

    public boolean isAirBlock() {
        return super.isAirBlock(this.world);
    }

    public boolean isBlockEqual(Block block) {
        return super.isBlockEqual(this.world, block);
    }

    public boolean isBlockFreezable() {
        return super.isBlockFreezable(this.world);
    }

    public boolean isReplaceable() {
        Block block = this.getBlock();
        return block == null || block == Blocks.field_150350_a || block.isAir((IBlockAccess)this.world, this.xi(), this.yi(), this.zi()) || this.getBlock().isReplaceable((IBlockAccess)this.world, this.xi(), this.yi(), this.zi());
    }

    public boolean canSeeSky() {
        return this.world == null ? false : this.world.func_72937_j(this.xi(), this.yi(), this.zi());
    }

    public boolean isChunkLoaded() {
        if (this.world instanceof WorldServer) {
            return ((WorldServer)this.world).field_73059_b.func_73149_a(this.xi() >> 4, this.zi() >> 4) && this.getChunk().field_76636_d;
        }
        return this.world.func_72863_F().func_73149_a(this.xi() >> 4, this.zi() >> 4) && this.getChunk().field_76636_d;
    }

    public Chunk getChunk() {
        return this.world.func_72938_d(this.xi(), this.zi());
    }

    public void markForUpdate() {
        super.markForUpdate(this.world);
    }

    public boolean equals(Object o) {
        return o instanceof AbstractLocation && this.world == ((AbstractLocation)((Object)o)).oldWorld() && ((AbstractLocation)((Object)o)).x() == this.x() && ((AbstractLocation)((Object)o)).y() == this.y() && ((AbstractLocation)((Object)o)).z() == this.z();
    }

    public String toString() {
        return "WorldLocation [" + this.x() + "x," + this.y() + "y," + this.z() + "z," + (this.world == null ? "n" : (this.world.field_73011_w == null ? "p" : Integer.valueOf(this.world.field_73011_w.field_76574_g))) + "d]";
    }
}

