/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.entity.cart;

import com.builtbroken.mc.api.rails.ITransportCart;
import com.builtbroken.mc.api.rails.ITransportRail;
import com.builtbroken.mc.api.rails.ITransportRailBlock;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.lib.helper.MathUtility;
import com.builtbroken.mc.prefab.entity.EntityBase;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class EntityAbstractCart
extends EntityBase
implements IPacketIDReceiver,
IEntityAdditionalSpawnData,
ITransportCart {
    public static final float PUSH_SPEED = 0.05f;
    public ForgeDirection railSide;
    public ForgeDirection railDirection;
    public ForgeDirection facingDirection = ForgeDirection.NORTH;
    public float railHeight = 0.3f;
    public float length = 3.0f;
    private boolean invalidBox = false;
    private boolean updateClient = true;
    @SideOnly(value=Side.CLIENT)
    public double lastRenderX;
    @SideOnly(value=Side.CLIENT)
    public double lastRenderY;
    @SideOnly(value=Side.CLIENT)
    public double lastRenderZ;

    public EntityAbstractCart(World world) {
        super(world);
        this.field_70131_O = 0.7f;
        this.field_70130_N = 0.95f;
    }

    public boolean func_85031_j(Entity entity) {
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            this.func_70076_C();
            return false;
        }
        return false;
    }

    public AxisAlignedBB func_70114_g(Entity entity) {
        return this.field_70121_D;
    }

    public AxisAlignedBB func_70046_E() {
        return this.field_70121_D;
    }

    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    public void func_70107_b(double x, double y, double z) {
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.invalidBox = true;
    }

    @Override
    public void setCartRotation(float yaw, float pitch) {
        super.func_70101_b(yaw, pitch);
        this.invalidBox = true;
        float yaw2 = (float)MathUtility.clampAngleTo180(this.field_70177_z);
        if (yaw2 >= -45.0f && yaw2 <= 45.0f) {
            this.facingDirection = ForgeDirection.NORTH;
        } else if (yaw2 <= -135.0f || yaw2 >= 135.0f) {
            this.facingDirection = ForgeDirection.SOUTH;
        } else if (yaw2 >= 45.0f && yaw2 <= 135.0f) {
            this.facingDirection = ForgeDirection.EAST;
        } else if (yaw2 >= -135.0f && yaw2 <= -45.0f) {
            this.facingDirection = ForgeDirection.WEST;
        }
    }

    @Override
    public float getDesiredPushVelocity() {
        return 0.05f;
    }

    protected void validateBoundBox() {
        this.invalidBox = false;
        float halfWidth = this.field_70130_N / 2.0f;
        float halfLength = this.length / 2.0f;
        float yaw = (float)Math.abs(MathUtility.clampAngleTo180(this.field_70177_z));
        if (yaw >= 45.0f && yaw <= 135.0f) {
            halfWidth = this.length / 2.0f;
            halfLength = this.field_70130_N / 2.0f;
        }
        this.field_70121_D.func_72324_b(this.field_70165_t - (double)halfWidth, this.field_70163_u - (double)this.field_70129_M + (double)this.field_70139_V, this.field_70161_v - (double)halfLength, this.field_70165_t + (double)halfWidth, this.field_70163_u - (double)this.field_70129_M + (double)this.field_70139_V + (double)this.field_70131_O, this.field_70161_v + (double)halfLength);
    }

    protected void markBoundsInvalid() {
        this.invalidBox = true;
    }

    protected void func_70105_a(float p_70105_1_, float p_70105_2_) {
    }

    public void func_70071_h_() {
        Pos pos;
        Block block;
        this.field_70141_P = this.field_70140_Q;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70127_C = this.field_70125_A;
        this.field_70126_B = this.field_70177_z;
        if (this.invalidBox || this.field_70121_D == null) {
            this.validateBoundBox();
        }
        if (this.railSide == null) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                Pos pos2 = (Pos)((Object)new Pos(this).add(side));
                Block block2 = pos2.getBlock((IBlockAccess)this.field_70170_p);
                TileEntity tile = pos2.getTileEntity((IBlockAccess)this.field_70170_p);
                if (block2 instanceof ITransportRailBlock || tile instanceof ITransportRail) continue;
                this.railSide = side;
                break;
            }
        }
        if ((block = (pos = (Pos)new Pos(Math.floor(this.field_70165_t), Math.floor(this.field_70163_u), Math.floor(this.field_70161_v)).floor()).getBlock((IBlockAccess)this.oldWorld())) == Blocks.field_150350_a) {
            pos = (Pos)((Object)pos.add(this.railSide));
            block = pos.getBlock((IBlockAccess)this.field_70170_p);
        }
        TileEntity tile = pos.getTileEntity((IBlockAccess)this.field_70170_p);
        if (!this.field_70170_p.field_72995_K) {
            if (this.field_70163_u < -64.0) {
                this.func_70076_C();
                return;
            }
            if (!(block instanceof ITransportRailBlock) && !(tile instanceof ITransportRail)) {
                this.destroyCart();
                return;
            }
            if (this.field_70159_w != 0.0 || this.field_70181_x != 0.0 || this.field_70179_y != 0.0) {
                this.func_70091_d(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                this.recenterCartOnRail();
            }
        }
        if (this.field_70160_al) {
            this.field_70181_x -= 0.49000000000000005;
            this.field_70181_x = Math.max(-2.0, this.field_70181_x);
        }
        this.doCollisionLogic();
        if (tile instanceof ITransportRail) {
            ((ITransportRail)tile).tickRailFromCart(this);
        } else if (block instanceof ITransportRailBlock) {
            ((ITransportRailBlock)block).tickRailFromCart(this, this.oldWorld(), pos.xi(), pos.yi(), pos.zi(), this.field_70170_p.func_72805_g(pos.xi(), pos.yi(), pos.zi()));
        }
        if (!this.field_70170_p.field_72995_K && this.updateClient) {
            this.sentDescriptionPacket();
        }
    }

    protected void markForClientSync() {
        this.updateClient = true;
    }

    @Override
    public void recenterCartOnRail() {
        this.recenterCartOnRail(this.railSide, this.railDirection, this.railHeight, false);
    }

    @Override
    public void recenterCartOnRail(ForgeDirection side, ForgeDirection facing, double railHeight, boolean trueCenter) {
        this.railDirection = facing;
        this.railHeight = (float)railHeight;
        this.railSide = side;
        if (side == ForgeDirection.UP) {
            this.field_70163_u = Math.floor(this.field_70163_u) + railHeight;
            this.field_70181_x = 0.0;
        } else if (side == ForgeDirection.DOWN) {
            this.field_70163_u = Math.floor(this.field_70163_u) + 1.0 - railHeight;
            this.field_70181_x = 0.0;
        }
        if (facing == ForgeDirection.NORTH || facing == ForgeDirection.SOUTH) {
            this.field_70159_w = 0.0;
            this.field_70165_t = Math.floor(this.field_70165_t) + 0.5;
            if (trueCenter) {
                this.field_70161_v = Math.floor(this.field_70161_v) + 0.5;
            }
        } else if (facing == ForgeDirection.EAST || facing == ForgeDirection.WEST) {
            this.field_70179_y = 0.0;
            this.field_70161_v = Math.floor(this.field_70161_v) + 0.5;
            if (trueCenter) {
                this.field_70165_t = Math.floor(this.field_70165_t) + 0.5;
            }
        }
    }

    @Override
    public void setCartMotion(double x, double y, double z) {
        this.field_70159_w = x;
        this.field_70181_x = y;
        this.field_70179_y = z;
    }

    protected void doCollisionLogic() {
        AxisAlignedBB box = this.field_70121_D.func_72314_b(0.2, 0.0, 0.2);
        List list = this.field_70170_p.func_72839_b((Entity)this, box);
        if (list != null && !list.isEmpty()) {
            for (Object aList : list) {
                Entity entity = (Entity)aList;
                if (entity == this.field_70153_n || !entity.func_70104_M()) continue;
                entity.func_70108_f((Entity)this);
            }
        }
    }

    public void func_70108_f(Entity entity) {
    }

    @SideOnly(value=Side.CLIENT)
    public float func_70053_R() {
        return 0.0f;
    }

    public void destroyCart() {
        InventoryUtility.dropItemStack(this, this.toStack());
        this.func_70106_y();
    }

    public ItemStack toStack() {
        return null;
    }

    public void func_70030_z() {
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
    }

    public void writeSpawnData(ByteBuf buffer) {
    }

    public void readSpawnData(ByteBuf additionalData) {
    }

    public ItemStack getPickedResult(MovingObjectPosition target) {
        return this.toStack();
    }
}

