/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.gui.components;

import com.builtbroken.jlib.data.vector.IPos2D;
import com.builtbroken.mc.prefab.gui.components.GuiComponent;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.GuiButton;
import org.lwjgl.opengl.GL11;

public class GuiComponentContainer<E extends GuiComponentContainer>
extends GuiComponent<E> {
    private final List<GuiComponent> components = new ArrayList<GuiComponent>();
    public boolean resizeAsNeeded = false;
    protected boolean updatePositionLogic = true;

    public GuiComponentContainer(int id, IPos2D point) {
        super(id, point);
    }

    public GuiComponentContainer(int id, int x, int y) {
        super(id, x, y);
    }

    public GuiComponentContainer(int id, int x, int y, int width, int height, String key) {
        super(id, x, y, width, height, key);
    }

    @Override
    public E setHeight(int height) {
        super.setHeight(height);
        if (this.updatePositionLogic) {
            this.updatePositions();
        }
        return (E)((Object)this);
    }

    @Override
    public E setWidth(int width) {
        super.setWidth(width);
        if (this.updatePositionLogic) {
            this.updatePositions();
        }
        return (E)((Object)this);
    }

    @Override
    public void updatePositions() {
        if (this.updatePositionLogic) {
            super.updatePositions();
            for (GuiComponent component : this.getComponents()) {
                component.updatePositions();
            }
        }
    }

    @Override
    protected void doRender(Minecraft mc, int mouseX, int mouseY) {
        super.doRender(mc, mouseX, mouseY);
        for (GuiComponent component : this.getComponents()) {
            GL11.glPushMatrix();
            component.func_146112_a(mc, mouseX, mouseY);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPopMatrix();
        }
    }

    public void func_146118_a(int mouseX, int mouseY) {
        super.func_146118_a(mouseX, mouseY);
        for (GuiComponent component : this.getComponents()) {
            component.func_146118_a(mouseX, mouseY);
        }
    }

    @Override
    public boolean func_146116_c(Minecraft mc, int mouseX, int mouseY) {
        if (super.func_146116_c(mc, mouseX, mouseY)) {
            for (GuiComponent component : this.getComponents()) {
                if (!component.func_146116_c(mc, mouseX, mouseY)) continue;
                this.actionPerformed(component);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean keyTyped(char c, int i) {
        for (GuiComponent component : this.getComponents()) {
            if (!component.keyTyped(c, i)) continue;
            return true;
        }
        return super.keyTyped(c, i);
    }

    public void func_146111_b(int mouseX, int mouseY) {
        super.func_146111_b(mouseX, mouseY);
        for (GuiComponent component : this.getComponents()) {
            component.func_146111_b(mouseX, mouseY);
        }
    }

    public void func_146113_a(SoundHandler handler) {
        for (GuiComponent component : this.getComponents()) {
            component.func_146113_a(handler);
        }
    }

    public void actionPerformed(GuiButton button) {
    }

    public <E extends GuiComponent> E add(E component) {
        if (component != null && !this.getComponents().contains(component)) {
            this.getComponents().add(component);
            component.setParentComponent(this);
            if (this.updatePositionLogic) {
                this.calcSize();
            }
        }
        return component;
    }

    public void remove(GuiComponent component) {
        if (component != null && this.getComponents().contains((Object)component)) {
            this.getComponents().remove((Object)component);
            if (this.updatePositionLogic) {
                this.updatePositions();
                this.calcSize();
            }
        }
    }

    protected void calcSize() {
        if (this.resizeAsNeeded) {
            int width = 0;
            int height = 0;
            for (GuiComponent component : this.getComponents()) {
                int sizeX = component.x() - this.field_146128_h + component.getWidth();
                int sizeY = component.y() - this.field_146128_h + component.getHeight();
                if (sizeX > width) {
                    width = sizeX;
                }
                if (sizeY <= height) continue;
                height = sizeY;
            }
            this.updatePositionLogic = false;
            this.setWidth(width);
            this.setHeight(height);
            this.updatePositionLogic = true;
        }
    }

    public List<GuiComponent> getComponents() {
        return this.components;
    }
}

