/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.prefab.tile.logic;

import com.builtbroken.mc.api.energy.IEnergyBuffer;
import com.builtbroken.mc.api.energy.IEnergyBufferProvider;
import com.builtbroken.mc.api.tile.ConnectionType;
import com.builtbroken.mc.api.tile.ITileConnection;
import com.builtbroken.mc.framework.block.imp.IChangeListener;
import com.builtbroken.mc.framework.energy.UniversalEnergySystem;
import com.builtbroken.mc.framework.energy.data.EnergyBuffer;
import com.builtbroken.mc.framework.logic.TileNode;
import com.builtbroken.mc.imp.transform.vector.Pos;
import com.builtbroken.mc.prefab.energy.EnergyBufferWrapper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class TilePowerNode
extends TileNode
implements ITileConnection,
IEnergyBufferProvider,
IChangeListener {
    protected EnergyBuffer energyBuffer;
    protected EnergyBufferWrapper[] sides = new EnergyBufferWrapper[6];
    protected int nextConnectionUpdate = 1;

    public TilePowerNode(String id, String mod) {
        super(id, mod);
    }

    @Override
    public void firstTick() {
        super.firstTick();
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.sides[dir.ordinal()] = this.createEnergySideWrapper();
        }
    }

    protected EnergyBufferWrapper createEnergySideWrapper() {
        return new EnergyBufferWrapper(this.getEnergyBuffer(ForgeDirection.UNKNOWN));
    }

    @Override
    public void update(long ticks) {
        super.update(ticks);
        this.updateConnections(ticks);
    }

    protected void updateConnections(long ticks) {
        if (this.sides != null && (ticks % (long)this.nextConnectionUpdate == 0L || ticks == -1L)) {
            Pos center = this.toPos();
            for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                if (this.sides[dir.ordinal()] == null) continue;
                this.sides[dir.ordinal()].setConnection(null);
                Pos pos = (Pos)((Object)center.add(dir));
                TileEntity tile = pos.getTileEntity((IBlockAccess)this.world().unwrap());
                if (!UniversalEnergySystem.isHandler(tile, dir.getOpposite()) || !this.canConnect(tile, ConnectionType.POWER, dir)) continue;
                this.sides[dir.ordinal()].setConnection(tile);
            }
            this.nextConnectionUpdate = 10 + ((World)this.world().unwrap()).field_73012_v.nextInt(100);
        }
    }

    @Override
    public void onBlockChanged() {
        this.nextConnectionUpdate = 1;
    }

    @Override
    public IEnergyBuffer getEnergyBuffer(ForgeDirection side) {
        if (this.getEnergyBufferSize() > 0) {
            if (this.energyBuffer == null) {
                this.energyBuffer = new EnergyBuffer(this.getEnergyBufferSize());
            }
            return side == ForgeDirection.UNKNOWN ? this.energyBuffer : this.sides[side.ordinal()];
        }
        return null;
    }

    @Override
    public boolean canConnect(TileEntity connection, ConnectionType type, ForgeDirection from) {
        return this.getEnergyBufferSize() > 0 && type == ConnectionType.POWER;
    }

    @Override
    public boolean hasConnection(ConnectionType type, ForgeDirection side) {
        if (type == ConnectionType.POWER) {
            return this.sides[side.ordinal()] != null && this.sides[side.ordinal()].hasConnection();
        }
        return false;
    }

    public int getEnergyBufferSize() {
        return 0;
    }

    @Override
    public void load(NBTTagCompound nbt) {
        super.load(nbt);
        if (nbt.func_74764_b("energy") && this.getEnergyBuffer(ForgeDirection.UNKNOWN) != null) {
            this.getEnergyBuffer(ForgeDirection.UNKNOWN).addEnergyToStorage(nbt.func_74762_e("energy"), true);
        }
    }

    @Override
    public NBTTagCompound save(NBTTagCompound nbt) {
        super.save(nbt);
        if (this.energyBuffer != null && this.energyBuffer.getEnergyStored() > 0) {
            nbt.func_74768_a("energy", this.energyBuffer.getEnergyStored());
        }
        return nbt;
    }
}

