/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.abstraction;

import com.builtbroken.mc.api.abstraction.data.IItemData;
import com.builtbroken.mc.api.abstraction.data.ITileData;
import com.builtbroken.mc.api.abstraction.entity.IEntityData;
import com.builtbroken.mc.api.abstraction.imp.IMinecraftInterface;
import com.builtbroken.mc.api.abstraction.tile.ITileMaterial;
import com.builtbroken.mc.api.abstraction.world.IWorld;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.seven.abstraction.data.ItemData;
import com.builtbroken.mc.seven.abstraction.data.TileData;
import com.builtbroken.mc.seven.abstraction.entity.EntityData;
import com.builtbroken.mc.seven.abstraction.tile.TileMaterial;
import com.builtbroken.mc.seven.abstraction.world.WorldWrapper;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;

public class MinecraftWrapper
implements IMinecraftInterface {
    public HashMap<String, TileMaterial> nameToMaterial = new HashMap();
    public HashMap<String, ItemData> nameToItem = new HashMap();
    public HashMap<String, TileData> nameToTile = new HashMap();
    public HashMap<Integer, WorldWrapper> worldToWrapper = new HashMap();
    public HashMap<Material, TileMaterial> materialToWrapper = new HashMap();
    public HashMap<Entity, IEntityData> entityToWrapper = new HashMap();
    public HashMap<Item, ItemData> itemToWrapper = new HashMap();
    public HashMap<Block, TileData> blockToWrapper = new HashMap();
    public static MinecraftWrapper INSTANCE;

    @Override
    public IWorld getWorld(int dim) {
        WorldWrapper worldWrapper = this.worldToWrapper.get(dim);
        if (worldWrapper != null && worldWrapper.isValid()) {
            return worldWrapper;
        }
        WorldServer world = DimensionManager.getWorld((int)dim);
        if (world != null) {
            worldWrapper = this.newWorldWrapper((World)world);
            this.worldToWrapper.put(dim, worldWrapper);
            return worldWrapper;
        }
        return null;
    }

    protected WorldWrapper newWorldWrapper(World world) {
        return new WorldWrapper(world);
    }

    @Override
    public ITileMaterial getTileMaterial(String name) {
        if (this.nameToMaterial.isEmpty()) {
            this.initMaterials();
        }
        return this.nameToMaterial.get(name);
    }

    @Override
    public IItemData getItemData(String key) {
        if (this.nameToItem.containsKey(key)) {
            return this.nameToItem.get(key);
        }
        Object item = Item.field_150901_e.func_82594_a(key);
        if (item instanceof Item) {
            ItemData data = new ItemData((Item)item);
            this.nameToItem.put(key, data);
            this.itemToWrapper.put((Item)item, data);
            return data;
        }
        return null;
    }

    @Override
    public ITileData getTileData(String key) {
        if (this.nameToTile.containsKey(key)) {
            return this.nameToTile.get(key);
        }
        Object block = Block.field_149771_c.func_82594_a(key);
        if (block instanceof Block && block != Blocks.field_150350_a) {
            TileData data = new TileData((Block)block);
            this.nameToTile.put(key, data);
            this.blockToWrapper.put((Block)block, data);
            return data;
        }
        return null;
    }

    @Override
    public boolean isShiftHeld() {
        return false;
    }

    @Override
    public EntityPlayer getLocalPlayer() {
        return null;
    }

    public ITileMaterial getTileMaterial(Material material) {
        if (this.materialToWrapper.containsKey(material)) {
            return this.materialToWrapper.get(material);
        }
        TileMaterial tileMaterial = new TileMaterial(material, material.getClass().getSimpleName() + "#" + material.hashCode());
        this.materialToWrapper.put(material, tileMaterial);
        return tileMaterial;
    }

    public void initMaterials() {
        this.addMaterial("air", Material.field_151579_a);
        this.addMaterial("grass", Material.field_151577_b);
        this.addMaterial("ground", Material.field_151578_c);
        this.addMaterial("wood", Material.field_151575_d);
        this.addMaterial("rock", Material.field_151576_e);
        this.addMaterial("stone", Material.field_151576_e);
        this.addMaterial("iron", Material.field_151573_f);
        this.addMaterial("metal", Material.field_151573_f);
        this.addMaterial("anvil", Material.field_151574_g);
        this.addMaterial("water", Material.field_151586_h);
    }

    public void addMaterial(String name, Material material) {
        String key = name.toLowerCase();
        if (this.nameToMaterial.containsKey(key)) {
            Engine.logger().warn("MinecraftWrapper#addMaterial(" + name + ", " + material + ") is overriding previous entry of " + this.nameToMaterial.get(key));
        }
        this.nameToMaterial.put(key, new TileMaterial(material, key));
    }

    public IEntityData get(Entity entity) {
        if (this.entityToWrapper.containsKey(entity)) {
            return this.entityToWrapper.get(entity);
        }
        EntityData data = new EntityData(entity);
        this.entityToWrapper.put(entity, data);
        return data;
    }

    public ITileData getTileData(Block block) {
        if (block != null) {
            if (this.blockToWrapper.containsKey(block)) {
                return this.blockToWrapper.get(block);
            }
            return this.getTileData(Block.field_149771_c.func_148750_c((Object)block));
        }
        return null;
    }

    public IItemData getItemData(Item item) {
        if (item != null) {
            if (this.itemToWrapper.containsKey(item)) {
                return this.itemToWrapper.get(item);
            }
            return this.getItemData(Item.field_150901_e.func_148750_c((Object)item));
        }
        return null;
    }
}

