/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.block;

import com.builtbroken.jlib.data.Colors;
import com.builtbroken.mc.api.data.ActionResponse;
import com.builtbroken.mc.api.tile.access.IGuiTile;
import com.builtbroken.mc.api.tile.node.ITileNodeHost;
import com.builtbroken.mc.client.json.ClientDataHandler;
import com.builtbroken.mc.client.json.imp.IRenderState;
import com.builtbroken.mc.client.json.render.RenderData;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.registry.ModManager;
import com.builtbroken.mc.framework.block.imp.IActivationListener;
import com.builtbroken.mc.framework.block.imp.IBlockListener;
import com.builtbroken.mc.framework.block.imp.IBlockStackListener;
import com.builtbroken.mc.framework.block.imp.IBoundListener;
import com.builtbroken.mc.framework.block.imp.IChangeListener;
import com.builtbroken.mc.framework.block.imp.ICollisionListener;
import com.builtbroken.mc.framework.block.imp.IDestroyedListener;
import com.builtbroken.mc.framework.block.imp.IFillRainListener;
import com.builtbroken.mc.framework.block.imp.IHardnessListener;
import com.builtbroken.mc.framework.block.imp.ILightLevelListener;
import com.builtbroken.mc.framework.block.imp.IPlacementListener;
import com.builtbroken.mc.framework.block.imp.IResistanceListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListener;
import com.builtbroken.mc.framework.block.imp.IToolListener;
import com.builtbroken.mc.framework.block.imp.IUpdateListener;
import com.builtbroken.mc.framework.block.imp.IWrenchListener;
import com.builtbroken.mc.framework.json.IJsonGenMod;
import com.builtbroken.mc.framework.json.imp.IJsonGenObject;
import com.builtbroken.mc.framework.json.imp.JsonLoadPhase;
import com.builtbroken.mc.lib.helper.LanguageUtility;
import com.builtbroken.mc.lib.helper.WrenchUtility;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.seven.abstraction.MinecraftWrapper;
import com.builtbroken.mc.seven.framework.block.BlockPropertyData;
import com.builtbroken.mc.seven.framework.block.ItemBlockBase;
import com.builtbroken.mc.seven.framework.block.listeners.ListenerIterator;
import com.builtbroken.mc.seven.framework.block.listeners.client.IIconListener;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.Stack;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;

public class BlockBase
extends BlockContainer
implements IJsonGenObject,
ITileEntityProvider {
    public final BlockPropertyData data;
    public IJsonGenMod mod;
    protected boolean registered = false;
    public final HashMap<String, List<ITileEventListener>> listeners = new HashMap();

    public BlockBase(BlockPropertyData data) {
        super(data.getMaterial());
        this.data = data;
        this.data.block = this;
        this.func_149663_c(data.localization.replace("${name}", data.name).replace("${mod}", data.getMod()));
        this.func_149752_b(data.getResistance());
        this.func_149711_c(data.getHardness());
        this.func_149676_a(data.getBlockBounds().min().xf(), data.getBlockBounds().min().yf(), data.getBlockBounds().min().zf(), data.getBlockBounds().max().xf(), data.getBlockBounds().max().yf(), data.getBlockBounds().max().zf());
        this.field_149787_q = this.func_149662_c();
        this.field_149786_r = this.func_149662_c() ? 255 : 0;
    }

    @Override
    public String getLoader() {
        return "block";
    }

    @Override
    public String getMod() {
        return this.data != null ? this.data.getMod() : null;
    }

    @Override
    public String getContentID() {
        return this.data.registryKey;
    }

    @Override
    public void register(IJsonGenMod mod, ModManager manager) {
        if (!this.registered) {
            this.mod = mod;
            this.registered = true;
            manager.newBlock(this.data.registryKey, this, this.getItemBlockClass());
            if (this.data.tileEntityProvider != null) {
                this.data.tileEntityProvider.register(this, mod, manager);
            }
        }
    }

    protected Class<? extends ItemBlock> getItemBlockClass() {
        return ItemBlockBase.class;
    }

    @Override
    public void onPhase(JsonLoadPhase phase) {
        if (phase == JsonLoadPhase.LOAD_PHASE_TWO && this.data.oreName != null) {
            OreDictionary.registerOre((String)this.data.oreName, (ItemStack)new ItemStack((Block)this));
        }
    }

    public String toString() {
        return "Block[" + this.data.name + "]";
    }

    public TileEntity func_149915_a(World world, int meta) {
        if (this.data.tileEntityProvider != null) {
            return this.data.tileEntityProvider.createNewTileEntity(this, world, meta);
        }
        return null;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return this.func_149915_a(world, meta);
    }

    public float func_149712_f(World world, int x, int y, int z) {
        float hardness = this.data.getHardness();
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "hardness");
        while (it.hasNext()) {
            float h;
            ITileEventListener next = it.next();
            if (!(next instanceof IHardnessListener) || !((h = ((IHardnessListener)next).getBlockHardness()) > hardness)) continue;
            hardness = h;
        }
        return hardness;
    }

    public float func_149737_a(EntityPlayer player, World world, int x, int y, int z) {
        boolean canHarvest;
        int metadata = world.func_72805_g(x, y, z);
        float hardness = 0.0f;
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "hardness");
        while (it.hasNext()) {
            float h;
            ITileEventListener next = it.next();
            if (!(next instanceof IHardnessListener) || !((h = ((IHardnessListener)next).getBlockHardness(player)) > hardness)) continue;
            hardness = h;
        }
        if (hardness == 0.0f) {
            hardness = this.data.getHardness();
        }
        float breakSpeed = !(canHarvest = this.canHarvestBlock(player, world, x, y, z, metadata)) ? player.getBreakSpeed((Block)this, true, metadata, x, y, z) / hardness / 100.0f : player.getBreakSpeed((Block)this, false, metadata, x, y, z) / hardness / 30.0f;
        return breakSpeed;
    }

    public boolean canHarvestBlock(EntityPlayer player, World world, int x, int y, int z, int meta) {
        if (this.func_149688_o().func_76229_l()) {
            return true;
        }
        ItemStack stack = player.field_71071_by.func_70448_g();
        String desiredHarvestTool = this.getHarvestTool(world, x, y, z, meta);
        int desiredHarvestLevel = this.getHarvestLevel(world, x, y, z, meta);
        if (stack == null || desiredHarvestTool == null) {
            return player.func_146099_a((Block)this);
        }
        int toolLevel = stack.func_77973_b().getHarvestLevel(stack, desiredHarvestTool);
        if (toolLevel < 0) {
            return player.func_146099_a((Block)this);
        }
        if (toolLevel >= desiredHarvestLevel) {
            ListenerIterator it = new ListenerIterator(world, x, y, z, this, "break");
            while (it.hasNext()) {
                ITileEventListener next = it.next();
                if (!(next instanceof IDestroyedListener) || ((IDestroyedListener)next).canHarvest(player, meta)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public String getHarvestTool(World world, int x, int y, int z, int meta) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "tool");
        while (it.hasNext()) {
            String tool;
            ITileEventListener next = it.next();
            if (!(next instanceof IToolListener) || (tool = ((IToolListener)next).getBlockHarvestTool(meta)) != null && tool.isEmpty()) continue;
            return tool;
        }
        return this.getHarvestTool(meta);
    }

    public String getHarvestTool(int metadata) {
        String tool;
        List<ITileEventListener> toolListeners = this.listeners.get("tool");
        if (toolListeners != null) {
            for (ITileEventListener next : toolListeners) {
                String tool2;
                if (!(next instanceof IToolListener) || (tool2 = ((IToolListener)next).getHarvestTool(metadata)) != null && tool2.isEmpty()) continue;
                return tool2;
            }
        }
        if ((tool = this.getBlockHarvestTool(metadata)) != null && !tool.isEmpty()) {
            return tool;
        }
        return super.getHarvestTool(metadata);
    }

    public int getHarvestLevel(World world, int x, int y, int z, int meta) {
        int level = this.getHarvestLevel(meta);
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "tool");
        while (it.hasNext()) {
            int l;
            ITileEventListener next = it.next();
            if (!(next instanceof IToolListener) || (l = ((IToolListener)next).getHarvestLevel(meta)) <= level) continue;
            level = l;
        }
        return level;
    }

    public int getHarvestLevel(int metadata) {
        List<ITileEventListener> toolListeners = this.listeners.get("tool");
        int level = super.getHarvestLevel(metadata);
        if (level < this.getBlockHarvestLevel(metadata)) {
            level = this.getBlockHarvestLevel(metadata);
        }
        if (toolListeners != null) {
            for (ITileEventListener next : toolListeners) {
                int l;
                if (!(next instanceof IToolListener) || (l = ((IToolListener)next).getBlockHarvestLevel(metadata)) <= level) continue;
                level = l;
            }
        }
        return level;
    }

    protected int getBlockHarvestLevel(int metadata) {
        return this.data.getHarvestLevel();
    }

    protected String getBlockHarvestTool(int metadata) {
        return this.data.getHarvestTool();
    }

    public void func_149639_l(World world, int x, int y, int z) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "rain");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IFillRainListener)) continue;
            ((IFillRainListener)next).onFilledWithRain();
        }
    }

    public float func_149638_a(Entity entity) {
        if (this.listeners.containsKey("resistance")) {
            float re = -1.0f;
            for (ITileEventListener listener : this.listeners.get("resistance")) {
                float value;
                if (!(listener instanceof IResistanceListener) || !((value = ((IResistanceListener)listener).getExplosionResistance(entity)) >= 0.0f) || !(value < re) && !(re < 0.0f)) continue;
                re = value;
            }
            if (re >= 0.0f) {
                return re;
            }
        }
        return this.data.getResistance() / 5.0f;
    }

    public float getExplosionResistance(Entity entity, World world, int x, int y, int z, double explosionX, double explosionY, double explosionZ) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "resistance");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IResistanceListener)) continue;
            ((IResistanceListener)next).getExplosionResistance(entity, explosionX, explosionY, explosionZ);
        }
        return this.func_149638_a(entity);
    }

    public void func_149726_b(World world, int x, int y, int z) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "placement");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IPlacementListener)) continue;
            ((IPlacementListener)next).onAdded();
        }
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLiving, ItemStack itemStack) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "placement");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IPlacementListener)) continue;
            ((IPlacementListener)next).onPlacedBy(entityLiving, itemStack);
        }
    }

    public void func_149714_e(World world, int x, int y, int z, int metadata) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "placement");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IPlacementListener)) continue;
            ((IPlacementListener)next).onPostPlaced(metadata);
        }
    }

    public void func_149723_a(World world, int x, int y, int z, Explosion ex) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "break");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IBlockListener)) continue;
            ((IDestroyedListener)next).onDestroyedByExplosion(ex);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int par6) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "break");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IBlockListener)) continue;
            ((IDestroyedListener)next).breakBlock(block, par6);
        }
        super.func_149749_a(world, x, y, z, block, par6);
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "break");
        boolean removed = false;
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IBlockListener) || !((IDestroyedListener)next).removedByPlayer(player, willHarvest)) continue;
            removed = true;
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest) || removed;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "change");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IChangeListener)) continue;
            ((IChangeListener)next).onNeighborBlockChange(block);
        }
    }

    public void onNeighborChange(IBlockAccess world, int x, int y, int z, int tileX, int tileY, int tileZ) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "change");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IChangeListener)) continue;
            ((IChangeListener)next).onNeighborChange(tileX, tileY, tileZ);
        }
    }

    public boolean func_149707_d(World world, int x, int y, int z, int side) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "placement");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IPlacementListener) || ((IPlacementListener)next).canPlaceOnSide(side) != ActionResponse.CANCEL) continue;
            return false;
        }
        return this.func_149742_c(world, x, y, z);
    }

    public boolean func_149742_c(World world, int x, int y, int z) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "placement");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IPlacementListener) || ((IPlacementListener)next).canPlaceAt() != ActionResponse.CANCEL) continue;
            return false;
        }
        return super.func_149742_c(world, x, y, z);
    }

    public boolean canPlaceBlockAt(Entity entity, World world, int x, int y, int z) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "placement");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IPlacementListener) || ((IPlacementListener)next).canPlaceAt(MinecraftWrapper.INSTANCE.get(entity)) != ActionResponse.CANCEL) continue;
            return false;
        }
        return this.func_149742_c(world, x, y, z);
    }

    public boolean func_149705_a(World world, int x, int y, int z, int side, ItemStack stack) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "placement");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IPlacementListener) || ((IPlacementListener)next).canReplace(world, x, y, z, side, stack) != ActionResponse.CANCEL) continue;
            return false;
        }
        return this.func_149707_d(world, x, y, z, side);
    }

    public boolean func_149718_j(World world, int x, int y, int z) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "placement");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IPlacementListener) || ((IPlacementListener)next).canBlockStay() != ActionResponse.CANCEL) continue;
            return false;
        }
        return true;
    }

    public void func_149699_a(World world, int x, int y, int z, EntityPlayer player) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "activation");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IActivationListener)) continue;
            ((IActivationListener)next).onPlayerClicked(player);
        }
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        try {
            Object o;
            int id;
            ITileEventListener next;
            ListenerIterator it;
            boolean activated = false;
            Object tile = this.getTile(world, x, y, z);
            if (WrenchUtility.isUsableWrench(player, player.field_71071_by.func_70448_g(), x, y, z)) {
                it = new ListenerIterator(world, x, y, z, this, "wrench");
                while (it.hasNext()) {
                    next = it.next();
                    if (!(next instanceof IWrenchListener) || !((IWrenchListener)next).handlesWrenchRightClick() || !((IWrenchListener)next).onPlayerRightClickWrench(player, side, hitX, hitY, hitZ)) continue;
                    activated = true;
                }
                if (activated) {
                    WrenchUtility.damageWrench(player, player.field_71071_by.func_70448_g(), x, y, z);
                }
                if (activated) {
                    return true;
                }
            }
            if (tile instanceof IGuiTile && ((IGuiTile)tile).shouldOpenOnRightClick(player) && (id = ((IGuiTile)tile).getDefaultGuiID(player)) >= 0 && (o = ((IGuiTile)tile).getServerGuiElement(id, player)) != null) {
                if (!world.field_72995_K) {
                    player.openGui((Object)this.mod, id, world, x, y, z);
                }
                activated = true;
            }
            it = new ListenerIterator(world, x, y, z, this, "activation");
            while (it.hasNext()) {
                next = it.next();
                if (!(next instanceof IActivationListener) || !((IActivationListener)next).onPlayerActivated(player, side, hitX, hitY, hitZ)) continue;
                activated = true;
            }
            return activated;
        }
        catch (Exception e) {
            this.outputError(world, x, y, z, "while right click block on side " + side, e);
            player.func_146105_b((IChatComponent)new ChatComponentText(Colors.RED.code + LanguageUtility.getLocal("blockTile.error.onBlockActivated")));
            return false;
        }
    }

    protected Object getTile(World world, int x, int y, int z) {
        TileEntity tile = world.func_147438_o(x, y, z);
        if (tile instanceof ITileNodeHost) {
            return ((ITileNodeHost)tile).getTileNode();
        }
        return tile;
    }

    public void func_149674_a(World world, int x, int y, int z, Random par5Random) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "update");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IUpdateListener)) continue;
            ((IUpdateListener)next).updateTick(par5Random);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random par5Random) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "update");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IUpdateListener)) continue;
            ((IUpdateListener)next).randomDisplayTick(par5Random);
        }
    }

    public void func_149670_a(World world, int x, int y, int z, Entity entity) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "update");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof ICollisionListener)) continue;
            ((ICollisionListener)next).onEntityCollidedWithBlock(entity);
        }
    }

    public void func_149743_a(World world, int x, int y, int z, AxisAlignedBB aabb, List list, Entity entity) {
        super.func_149743_a(world, x, y, z, aabb, list, entity);
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "bounds");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IBoundListener)) continue;
            ArrayList collect = new ArrayList();
            ((IBoundListener)next).addCollisionBoxesToList(aabb, collect, entity);
            for (Object object : collect) {
                boolean interest;
                if (!(object instanceof AxisAlignedBB) || !(interest = aabb.func_72326_a((AxisAlignedBB)object))) continue;
                list.add(object);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_149633_g(World world, int x, int y, int z) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "bounds");
        while (it.hasNext()) {
            AxisAlignedBB bound;
            ITileEventListener next = it.next();
            if (!(next instanceof IBoundListener) || (bound = ((IBoundListener)next).getSelectedBounds()) == null) continue;
            return bound;
        }
        return this.data.getSelectionBounds().clone().add(x, y, z).toAABB();
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "bounds");
        while (it.hasNext()) {
            AxisAlignedBB bound;
            ITileEventListener next = it.next();
            if (!(next instanceof IBoundListener) || (bound = ((IBoundListener)next).getCollisionBounds()) == null) continue;
            return bound;
        }
        return this.data.getBlockBounds().clone().add(x, y, z).toAABB();
    }

    public boolean func_149646_a(IBlockAccess access, int x, int y, int z, int side) {
        return super.func_149646_a(access, x, y, z, side);
    }

    public boolean func_149747_d(IBlockAccess access, int x, int y, int z, int side) {
        return this.data.isSolid() || super.func_149747_d(access, x, y, z, side);
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return this.data.isSolid() || this.isNormalCube(world, x, y, z);
    }

    public boolean isNormalCube(IBlockAccess world, int x, int y, int z) {
        return this.data.isNormalCube() || this.func_149688_o().func_76218_k() && this.func_149686_d() && !this.func_149744_f();
    }

    public int getLightValue(IBlockAccess access, int x, int y, int z) {
        int lightValue = 0;
        ListenerIterator it = new ListenerIterator(access, x, y, z, this, "light");
        while (it.hasNext()) {
            int level;
            ITileEventListener next = it.next();
            if (!(next instanceof ILightLevelListener) || (level = ((ILightLevelListener)next).getLightLevel()) < 0 || level > 15 || level <= lightValue) continue;
            lightValue = level;
        }
        if (lightValue > 0) {
            return lightValue;
        }
        if (this.data != null && this.data.getLightValue() > 0) {
            return this.data.getLightValue();
        }
        return 0;
    }

    public boolean func_149740_M() {
        return this.data != null ? this.data.hasComparatorInputOverride() : false;
    }

    public boolean func_149662_c() {
        return this.data != null ? this.data.isOpaqueCube() : false;
    }

    public boolean func_149686_d() {
        return this.data != null ? this.data.renderAsNormalBlock() : true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149645_b() {
        return this.data != null ? this.data.getRenderType() : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        int meta = world.func_72805_g(x, y, z);
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "icon");
        while (it.hasNext()) {
            IIcon icon;
            ITileEventListener next = it.next();
            if (!(next instanceof IIconListener) || (icon = ((IIconListener)next).getTileIcon(side, meta)) == null) continue;
            return icon;
        }
        return this.func_149691_a(side, meta);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int meta) {
        if (this.listeners.containsKey("icon")) {
            for (ITileEventListener listener : this.listeners.get("icon")) {
                IIcon icon;
                if (!(listener instanceof IIconListener) || listener instanceof IBlockListener || (icon = ((IIconListener)listener).getTileIcon(side, meta)) == null) continue;
                return icon;
            }
        }
        return this.getIconFromJson(side, meta);
    }

    public IIcon getIconFromJson(int side, int meta) {
        RenderData data = this.getRenderData(meta);
        if (data != null) {
            Stack<String> stack = new Stack<String>();
            this.getRenderStates(stack, side, meta);
            while (!stack.isEmpty()) {
                IIcon icon;
                IRenderState state;
                String key = stack.pop();
                if (key == null || (state = data.getState(key)) == null || (icon = state.getIcon(side)) == null) continue;
                return icon;
            }
        }
        return Blocks.field_150325_L.func_149691_a(0, side);
    }

    protected void getRenderStates(Stack<String> stack, int side, int meta) {
        stack.push("tile");
        stack.push("block");
        stack.push("tile." + meta);
        stack.push("tile." + ForgeDirection.getOrientation((int)meta).name().toLowerCase());
        stack.push("block." + meta);
        stack.push("block." + ForgeDirection.getOrientation((int)meta).name().toLowerCase());
    }

    public RenderData getRenderData(int meta) {
        return ClientDataHandler.INSTANCE.getRenderData(this.getContentID(meta));
    }

    public String getContentID(int meta) {
        if (this.data == null) {
            return this.getClass().getName();
        }
        return this.data.getMod() + ":" + this.data.registryKey;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess access, int x, int y, int z) {
        return super.func_149720_d(access, x, y, z);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        if (this.data != null && this.data.getColor() >= 0) {
            return this.data.getColor();
        }
        return super.func_149635_D();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int meta) {
        if (this.data != null && this.data.getColor() >= 0) {
            return this.data.getColor();
        }
        return this.func_149635_D();
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z, EntityPlayer player) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "blockStack");
        while (it.hasNext()) {
            ItemStack stack;
            ITileEventListener next = it.next();
            if (!(next instanceof IBlockStackListener) || (stack = ((IBlockStackListener)next).getPickBlock(target, player)) == null || stack.func_77973_b() == null) continue;
            return stack;
        }
        return super.getPickBlock(target, world, x, y, z, player);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList items = super.getDrops(world, x, y, z, metadata, fortune);
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "blockStack");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IBlockStackListener)) continue;
            ((IBlockStackListener)next).collectDrops(items, metadata, fortune);
        }
        return items;
    }

    public Item func_149650_a(int meta, Random random, int fortune) {
        if (this.data != null && this.data.getItemToDrop() != null) {
            return this.data.getItemToDrop();
        }
        return Item.func_150898_a((Block)this);
    }

    public int quantityDropped(int meta, int fortune, Random random) {
        if (this.data != null) {
            return this.data.getItemDropCount();
        }
        return 1;
    }

    public void func_149666_a(Item item, CreativeTabs creativeTabs, List list) {
        super.func_149666_a(item, creativeTabs, list);
        if (this.listeners.containsKey("blockStack")) {
            for (ITileEventListener listener : this.listeners.get("blockStack")) {
                if (!(listener instanceof IBlockStackListener)) continue;
                ((IBlockStackListener)listener).getSubBlocks(item, creativeTabs, list);
            }
        }
    }

    public boolean func_149744_f() {
        return this.data != null && this.data.isSupportsRedstone();
    }

    public int func_149709_b(IBlockAccess access, int x, int y, int z, int side) {
        return 0;
    }

    public int func_149748_c(IBlockAccess access, int x, int y, int z, int side) {
        return 0;
    }

    public void func_149719_a(IBlockAccess access, int x, int y, int z) {
        ListenerIterator it = new ListenerIterator(access, x, y, z, this, "bounds");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IBoundListener)) continue;
            ((IBoundListener)next).setBlockBoundsBasedOnState();
        }
    }

    public void func_149683_g() {
        if (this.listeners.containsKey("bounds")) {
            for (ITileEventListener listener : this.listeners.get("bounds")) {
                if (!(listener instanceof IBoundListener)) continue;
                ((IBoundListener)listener).setBlockBoundsForItemRender();
            }
        }
    }

    protected void func_149642_a(World world, int x, int y, int z, ItemStack itemStack) {
        ListenerIterator it = new ListenerIterator(world, x, y, z, this, "blockStack");
        while (it.hasNext()) {
            ITileEventListener next = it.next();
            if (!(next instanceof IBlockStackListener)) continue;
            ((IBlockStackListener)next).dropBlockAsItem(itemStack);
        }
        if (itemStack != null && itemStack.func_77973_b() != null) {
            InventoryUtility.dropItemStack(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, itemStack, 0, 0.0f);
        }
    }

    public int func_149701_w() {
        return this.data != null && this.data.isAlpha() ? 1 : 0;
    }

    public int func_149738_a(World world) {
        int tickRate = super.func_149738_a(world);
        for (ITileEventListener next : this.listeners.get("update")) {
            int r;
            if (!(next instanceof IUpdateListener) || (r = ((IUpdateListener)next).tickRate(world)) <= 0 || r >= tickRate) continue;
            tickRate = r;
        }
        return tickRate;
    }

    protected void outputError(World world, int x, int y, int z, String msg, Throwable e) {
        String dim = "null";
        if (world != null && world.field_73011_w != null) {
            dim = "" + world.field_73011_w.field_76574_g;
        }
        Engine.logger().error("Error: " + msg + " \nLocation[" + dim + "w " + x + "x " + y + "y " + z + "z]", e);
    }

    public void addListener(ITileEventListener listener) {
        List<String> keys;
        if (listener != null && (keys = listener.getListenerKeys()) != null && !keys.isEmpty()) {
            for (String key : keys) {
                if (key == null) continue;
                List<ITileEventListener> listeners = this.listeners.get(key);
                if (listeners == null) {
                    listeners = new ArrayList<ITileEventListener>();
                }
                listeners.add(listener);
                this.listeners.put(key, listeners);
            }
        }
    }
}

