/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.block;

import com.builtbroken.mc.client.json.ClientDataHandler;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.framework.json.loading.JsonProcessorData;
import com.builtbroken.mc.framework.json.override.JsonOverride;
import com.builtbroken.mc.framework.json.processors.JsonGenData;
import com.builtbroken.mc.framework.json.settings.JsonSettingData;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.lib.helper.MaterialDict;
import com.builtbroken.mc.prefab.inventory.InventoryUtility;
import com.builtbroken.mc.seven.framework.block.BlockBase;
import com.builtbroken.mc.seven.framework.block.tile.ITileProvider;
import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import net.minecraft.block.material.Material;
import net.minecraft.item.Item;

public class BlockPropertyData
extends JsonGenData {
    public final String registryKey;
    public final String MOD;
    public final String name;
    public String localization = "${mod}:${name}";
    public String oreName;
    public ITileProvider tileEntityProvider;
    public BlockBase block;
    private Material material = Material.field_151571_B;
    private String materialName = "clay";
    private String itemToDrop = null;
    private String harvestTool = null;
    private boolean isOpaqueCube;
    private boolean renderAsNormalBlock = true;
    private boolean supportsRedstone = false;
    private boolean hasComparatorInputOverride = false;
    private boolean isAlpha = false;
    private boolean isSolid = false;
    private boolean isNormalCube = false;
    private boolean canSilkHarvest = false;
    private float hardness = 5.0f;
    private float resistance = 5.0f;
    private int renderType = 0;
    private int color = -1;
    private int lightValue;
    private int itemDropCount = 1;
    private int harvestLevel = -1;
    private Cube renderBounds = Cube.FULL;
    private Cube blockBounds = Cube.FULL;
    private Cube selectionBounds = Cube.FULL;
    private HashMap<String, JsonSettingData> settings = new HashMap();

    public BlockPropertyData(IJsonProcessor processor, String registryKey, String MOD, String name) {
        super(processor);
        this.registryKey = registryKey;
        this.MOD = MOD;
        this.name = name;
    }

    @Override
    public String getMod() {
        return this.MOD;
    }

    @Override
    public String getContentID() {
        return this.registryKey;
    }

    public Material getMaterial() {
        return this.material;
    }

    @JsonProcessorData(value={"material"})
    public void setMaterial(String matName) {
        this.materialName = matName;
        this.material = MaterialDict.get(matName);
    }

    public float getHardness() {
        return this.hardness;
    }

    @JsonOverride
    @JsonProcessorData(value={"hardness"}, type="float")
    public void setHardness(float hardness) {
        this.hardness = hardness;
    }

    public float getResistance() {
        return this.resistance;
    }

    @JsonOverride
    @JsonProcessorData(value={"resistance"}, type="float")
    public void setResistance(float resistance) {
        this.resistance = resistance;
    }

    public int getRenderType() {
        return this.renderType;
    }

    @JsonProcessorData(value={"renderType"}, type="int", loadForServer=false)
    @SideOnly(value=Side.CLIENT)
    public void setRenderType(int renderType) {
        this.renderType = renderType;
    }

    @JsonProcessorData(value={"renderTypeName"}, loadForServer=false)
    @SideOnly(value=Side.CLIENT)
    public void setRenderTypeName(String renderType) {
        ISimpleBlockRenderingHandler handler = ClientDataHandler.INSTANCE.getBlockRender(renderType);
        if (handler == null) {
            throw new IllegalArgumentException("RenderType[" + renderType + "] was not registered and thus can't be used.");
        }
        this.setRenderType(handler.getRenderId());
    }

    public int getColor() {
        return this.color;
    }

    @JsonProcessorData(value={"renderColor"}, type="int")
    public void setColor(int color) {
        this.color = color;
    }

    public boolean isOpaqueCube() {
        return this.isOpaqueCube;
    }

    @JsonProcessorData(value={"isOpaqueCube", "isOpaque"})
    public void setOpaqueCube(boolean opaqueCube) {
        this.isOpaqueCube = opaqueCube;
    }

    public boolean isSupportsRedstone() {
        return this.supportsRedstone;
    }

    @JsonProcessorData(value={"supportsRedstone"})
    public void setSupportsRedstone(boolean supportsRedstone) {
        this.supportsRedstone = supportsRedstone;
    }

    public boolean isAlpha() {
        return this.isAlpha;
    }

    @JsonProcessorData(value={"hasAlphaTextures"}, loadForServer=false)
    public void setAlpha(boolean alpha) {
        this.isAlpha = alpha;
    }

    public int getLightValue() {
        return this.lightValue;
    }

    @JsonOverride
    @JsonProcessorData(value={"lightOutput"}, type="int")
    public void setLightValue(int lightValue) {
        this.lightValue = lightValue;
    }

    @JsonProcessorData(value={"renderAsNormalBlock"})
    public void setRenderAsNormalBlock(boolean b) {
        this.renderAsNormalBlock = b;
    }

    public boolean renderAsNormalBlock() {
        return this.renderAsNormalBlock;
    }

    @JsonProcessorData(value={"hasComparatorInputOverride"})
    public void setHasComparatorInputOverride(boolean b) {
        this.hasComparatorInputOverride = b;
    }

    public boolean hasComparatorInputOverride() {
        return this.hasComparatorInputOverride;
    }

    public Cube getRenderBounds() {
        return this.renderBounds;
    }

    @JsonProcessorData(value={"renderBounds"}, type="cube")
    public void setRenderBounds(Cube renderBounds) {
        this.renderBounds = renderBounds;
    }

    public Cube getBlockBounds() {
        return this.blockBounds;
    }

    @JsonProcessorData(value={"blockBounds"}, type="cube")
    public void setBlockBounds(Cube blockBounds) {
        this.blockBounds = blockBounds;
        if (this.block != null) {
            this.block.func_149676_a(blockBounds.min().xf(), blockBounds.min().yf(), blockBounds.min().zf(), blockBounds.max().xf(), blockBounds.max().yf(), blockBounds.max().zf());
        }
    }

    public Cube getSelectionBounds() {
        return this.selectionBounds;
    }

    @JsonProcessorData(value={"selectionBounds"}, type="cube")
    public void setSelectionBounds(Cube blockBounds) {
        this.selectionBounds = blockBounds;
    }

    public boolean isCanSilkHarvest() {
        return this.canSilkHarvest;
    }

    @JsonProcessorData(value={"canSilkHarvest"})
    public void setCanSilkHarvest(boolean canSilkHarvest) {
        this.canSilkHarvest = canSilkHarvest;
    }

    public int getItemDropCount() {
        return this.itemDropCount;
    }

    @JsonOverride
    @JsonProcessorData(value={"itemDropCount"}, type="int")
    public void setItemDropCount(int count) {
        this.itemDropCount = count;
    }

    public Item getItemToDrop() {
        return this.itemToDrop != null ? InventoryUtility.getItem(this.itemToDrop) : null;
    }

    @JsonProcessorData(value={"itemToDrop"})
    public void setItemToDrop(String item) {
        this.itemToDrop = item;
    }

    public boolean isSolid() {
        return this.isSolid;
    }

    @JsonProcessorData(value={"isSolid"})
    public void setSolid(boolean solid) {
        this.isSolid = solid;
    }

    public boolean isNormalCube() {
        return this.isNormalCube;
    }

    @JsonProcessorData(value={"isNormalCube"})
    public void setNormalCube(boolean normalCube) {
        this.isNormalCube = normalCube;
    }

    public int getHarvestLevel() {
        return this.harvestLevel;
    }

    @JsonOverride
    @JsonProcessorData(value={"harvestToolLevel"}, type="int")
    public void setHarvestLevel(int harvestLevel) {
        this.harvestLevel = harvestLevel;
    }

    public String getHarvestTool() {
        return this.harvestTool;
    }

    @JsonOverride
    @JsonProcessorData(value={"harvestTool"})
    public void setHarvestTool(String harvestTool) {
        this.harvestTool = harvestTool;
    }

    public HashMap<String, JsonSettingData> getSettings() {
        return this.settings;
    }

    public JsonSettingData getSetting(String key) {
        return this.settings.get(key);
    }

    public boolean hasSetting(String key) {
        return this.getSetting(key) != null;
    }

    public int getSettingAsInt(String key) {
        JsonSettingData data = this.getSetting(key);
        if (data != null) {
            return data.getInt();
        }
        return 0;
    }
}

