/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.json.recipe.crafting.shaped;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.framework.recipe.item.grid.RecipeShapedOreLarge;
import com.builtbroken.mc.seven.framework.json.recipe.crafting.JsonCraftingRecipeData;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class JsonShapedRecipeData
extends JsonCraftingRecipeData {
    public final Object[] data;
    public final boolean largeGrid;

    public JsonShapedRecipeData(IJsonProcessor processor, Object output, Object[] data, boolean largeGrid) {
        super(processor, output, data);
        this.data = data;
        this.largeGrid = largeGrid;
    }

    @Override
    public void convertData() {
        boolean convert = false;
        int gridEnd = 0;
        for (int i = 0; i < this.data.length; ++i) {
            Object dataObject = this.data[i];
            if (dataObject instanceof Character) {
                if (gridEnd == 0) {
                    gridEnd = i;
                }
                convert = true;
                continue;
            }
            if (!convert) continue;
            Object out = this.convert(dataObject);
            if (out != null) {
                this.data[i] = out;
                continue;
            }
            Engine.logger().error("JsonCraftingRecipeData: The item value of [" + dataObject + "] could not be parsed into a valid recipe item entry. Recipe -> " + this);
            this.broken = true;
        }
    }

    protected Object convert(Object in) {
        return this.convertItemEntry(in);
    }

    @Override
    public IRecipe getRecipe() {
        if (!this.broken) {
            if (this.output instanceof Block) {
                if (this.largeGrid) {
                    return new RecipeShapedOreLarge((Block)this.output, this.data);
                }
                return new ShapedOreRecipe((Block)this.output, this.data);
            }
            if (this.output instanceof Item) {
                if (this.largeGrid) {
                    return new RecipeShapedOreLarge((Item)this.output, this.data);
                }
                return new ShapedOreRecipe((Item)this.output, this.data);
            }
            if (this.output instanceof ItemStack) {
                if (this.largeGrid) {
                    return new RecipeShapedOreLarge((ItemStack)this.output, this.data);
                }
                return new ShapedOreRecipe((ItemStack)this.output, this.data);
            }
            Engine.logger().error("The type of output value [" + this.output + "] could not be recognized for recipe creation. Recipe -> " + this);
        }
        return null;
    }

    @Override
    public String toString() {
        return "JsonShapedRecipeData[ out = " + this.output + ", data = " + this.data + "]";
    }

    @Override
    public String getContentID() {
        return null;
    }
}

