/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.json.recipe.crafting.shaped;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.content.tool.ItemSimpleCraftingTool;
import com.builtbroken.mc.framework.json.imp.IJsonProcessor;
import com.builtbroken.mc.framework.recipe.item.RecipeTool;
import com.builtbroken.mc.seven.framework.json.recipe.crafting.shaped.JsonShapedRecipeData;
import java.util.HashMap;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;

public class JsonToolRecipeData
extends JsonShapedRecipeData {
    protected static HashMap<String, Function<String, ItemStack>> toolFactories = new HashMap();

    public JsonToolRecipeData(IJsonProcessor processor, Object output, Object[] data, boolean largeGrid) {
        super(processor, output, data, largeGrid);
    }

    @Override
    public IRecipe getRecipe() {
        if (!this.broken) {
            if (this.output instanceof Block) {
                return new RecipeTool((Block)this.output, this.data);
            }
            if (this.output instanceof Item) {
                return new RecipeTool((Item)this.output, this.data);
            }
            if (this.output instanceof ItemStack) {
                return new RecipeTool((ItemStack)this.output, this.data);
            }
            String msg = "The type of output value [" + this.output + "] could not be recognized for recipe creation";
            Engine.logger().error(msg + ". Recipe -> " + this);
            this.addError("RecipeCreation", msg, null);
        }
        return null;
    }

    @Override
    protected Object convert(Object in) {
        try {
            String value;
            if (in instanceof String && (value = (String)in).startsWith("tool@")) {
                value = value.substring(5, value.length());
                if (toolFactories.containsKey(value = value.toLowerCase().trim())) {
                    ItemStack stack = toolFactories.get(value).apply(value);
                    if (stack != null && stack.func_77973_b() != null) {
                        return stack;
                    }
                    this.addError("ConversionError", "Failed to convert tool entry [" + in + "] to tool due to [" + toolFactories.get(value) + "] returning an invalid stack [" + stack + "]", null);
                } else {
                    this.addError("ConversionError", "Failed to convert tool entry [" + in + "] to tool due to no factory for type", null);
                }
            }
            return this.convertItemEntry(in);
        }
        catch (Exception e) {
            String msg = "Unexpected error while converting [" + in + "] to usable recipe entry.";
            Engine.logger().error("JsonToolRecipeData: " + msg, (Throwable)e);
            this.addError("ConversionError", msg, null);
            return null;
        }
    }

    @Override
    public String toString() {
        return "JsonToolRecipeData[ out = " + this.output + ", data = " + this.data + "]";
    }

    @Override
    public String getContentID() {
        return null;
    }

    static {
        toolFactories.put("hammer", s -> ItemSimpleCraftingTool.getHammer());
        toolFactories.put("chisel", s -> ItemSimpleCraftingTool.getChisel());
        toolFactories.put("drill", s -> ItemSimpleCraftingTool.getDrill());
        toolFactories.put("cutter", s -> ItemSimpleCraftingTool.getCutters());
        toolFactories.put("file", s -> ItemSimpleCraftingTool.getFile());
    }
}

