/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.json.recipe.smelting;

import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.framework.json.data.JsonItemEntry;
import com.builtbroken.mc.seven.framework.block.IJsonBlockSubProcessor;
import com.builtbroken.mc.seven.framework.json.recipe.JsonRecipeProcessor;
import com.builtbroken.mc.seven.framework.json.recipe.smelting.JsonFurnaceRecipeData;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

public class JsonFurnaceRecipeProcessor
extends JsonRecipeProcessor<JsonFurnaceRecipeData>
implements IJsonBlockSubProcessor {
    @Override
    public String getMod() {
        return "voltzengine";
    }

    @Override
    public String getJsonKey() {
        return "furnaceRecipe";
    }

    @Override
    public String getLoadOrder() {
        return "after:oreName";
    }

    @Override
    public JsonFurnaceRecipeData process(Object out, JsonElement element) {
        Object input;
        JsonObject recipeData = element.getAsJsonObject();
        JsonFurnaceRecipeProcessor.ensureValuesExist(recipeData, "input");
        Object output = out;
        if (output == null) {
            JsonFurnaceRecipeProcessor.ensureValuesExist(recipeData, "output");
            output = JsonFurnaceRecipeProcessor.getItemFromJson(recipeData.get("output"));
        }
        if ((input = JsonFurnaceRecipeProcessor.getItemFromJson(recipeData.get("input"))) instanceof JsonItemEntry && ((JsonItemEntry)input).nbt != null) {
            Engine.logger().error("JsonFurnaceRecipeProcessor: NBT is not supported for smelting recipe input, recipe: '" + input + "' -> '" + output + "'");
        }
        float xp = 0.0f;
        if (recipeData.has("xp") && (xp = recipeData.getAsJsonPrimitive("xp").getAsFloat()) < 0.0f) {
            throw new IllegalArgumentException("JsonFurnaceRecipeProcessor: xp for recipe must be positive, recipe: '" + input + "' -> '" + output + "'");
        }
        return new JsonFurnaceRecipeData(this, input, output, xp);
    }
}

