/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.mc.seven.framework.logic;

import com.builtbroken.mc.api.abstraction.world.IWorld;
import com.builtbroken.mc.api.data.IPacket;
import com.builtbroken.mc.api.event.tile.TileEvent;
import com.builtbroken.mc.api.tile.ITile;
import com.builtbroken.mc.api.tile.node.ITileNode;
import com.builtbroken.mc.api.tile.node.ITileNodeHost;
import com.builtbroken.mc.core.Engine;
import com.builtbroken.mc.core.network.IPacketIDReceiver;
import com.builtbroken.mc.core.network.packet.PacketTile;
import com.builtbroken.mc.core.network.packet.PacketType;
import com.builtbroken.mc.framework.block.imp.IBlockListener;
import com.builtbroken.mc.framework.block.imp.IRenderBoundsListener;
import com.builtbroken.mc.framework.block.imp.ITileEventListener;
import com.builtbroken.mc.framework.block.imp.ITileWithListeners;
import com.builtbroken.mc.framework.block.imp.IUpdateListener;
import com.builtbroken.mc.framework.logic.imp.ITileDesc;
import com.builtbroken.mc.imp.transform.region.Cube;
import com.builtbroken.mc.seven.framework.block.BlockBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityWrapper
extends TileEntity
implements ITileNodeHost,
ITileWithListeners,
IPacketIDReceiver,
ITile {
    protected final ITileNode tile;
    public long ticks = 0L;
    protected int nextCleanupTick = 200;
    protected final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    protected final HashMap<String, List<ITileEventListener>> listeners = new HashMap();
    private AxisAlignedBB renderBoundCache;
    private IWorld _worldCache;

    public TileEntityWrapper(ITileNode controller) {
        this.tile = controller;
        this.tile.setHost(this);
    }

    public final void func_145845_h() {
        for (List list : new List[]{this.getListeners("multiblock"), ((BlockBase)this.func_145838_q()).listeners.get("multiblock")}) {
            if (list == null || list.isEmpty()) continue;
            for (ITileEventListener listener : list) {
                if (!(listener instanceof IUpdateListener)) continue;
                try {
                    if (listener instanceof IBlockListener) {
                        ((IBlockListener)((Object)listener)).inject(this.world(), this.xi(), this.yi(), this.zi());
                    }
                    ((IUpdateListener)listener).update(this.ticks);
                }
                catch (Exception e) {
                    Engine.logger().error("Unexpected exception while calling first tick on " + this.tile + "\nWrapper:" + this, (Throwable)e);
                }
            }
        }
        if (this.ticks == 0L) {
            try {
                this.tile.firstTick();
            }
            catch (Exception e) {
                Engine.logger().error("Unexpected exception while calling first tick on " + this.tile + "\nWrapper:" + this, (Throwable)e);
            }
        } else {
            try {
                this.tile.update(this.ticks);
            }
            catch (Exception e) {
                Engine.logger().error("Unexpected exception while ticking " + this.tile + "\nTick:" + this.ticks + "\nWrapper:" + this, (Throwable)e);
            }
        }
        if (this.ticks >= Long.MAX_VALUE) {
            this.ticks = 0L;
        }
        ++this.ticks;
        if (this.ticks % (long)this.nextCleanupTick == 0L) {
            this.tile.doCleanupCheck();
            this.nextCleanupTick = this.tile.getNextCleanupTick();
        }
        if (this.playersUsing.size() > 0) {
            // empty if block
        }
        this.field_145850_b.func_147476_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (TileEntity)this);
    }

    public boolean canUpdate() {
        return this.getTileNode().requiresPerTickUpdate();
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.field_145846_f = true;
        if (!this.field_145850_b.field_72995_K) {
            TileEvent.onUnLoad(this);
        }
        this.tile.destroy();
    }

    public void func_145829_t() {
        super.func_145829_t();
        this.field_145846_f = false;
        if (!this.field_145850_b.field_72995_K) {
            TileEvent.onLoad(this);
        }
    }

    @Override
    public boolean isHostValid() {
        return !this.func_145837_r();
    }

    @Override
    public boolean read(ByteBuf buf, int id, EntityPlayer player, PacketType type) {
        if (this.getTileNode() instanceof IPacketIDReceiver) {
            return ((IPacketIDReceiver)((Object)this.getTileNode())).read(buf, id, player, type);
        }
        return false;
    }

    public Packet func_145844_m() {
        if (this.tile instanceof ITileDesc) {
            return ((ITileDesc)((Object)this.tile)).canHandlePackets() ? Engine.packetHandler.toMCPacket(((ITileDesc)((Object)this.tile)).getDescPacket()) : null;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tile.load(nbt.func_74764_b("tileData") ? nbt.func_74775_l("tileData") : nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74782_a("tileData", (NBTBase)this.tile.save(new NBTTagCompound()));
    }

    @Override
    public PacketTile getPacketForData(Object ... data) {
        return new PacketTile(this, data);
    }

    @Override
    public void sendPacketToClient(IPacket packet, double range) {
        if (packet != null) {
            Engine.packetHandler.sendToAllAround(packet, this, range);
        }
    }

    @Override
    public void sendPacketToServer(IPacket packet) {
        if (packet != null) {
            Engine.packetHandler.sendToServer(packet);
        }
    }

    @Override
    public ITileNode getTileNode() {
        return this.tile;
    }

    public BlockBase getHostBlock() {
        return (BlockBase)this.func_145838_q();
    }

    @Override
    public int getHostMeta() {
        return this.func_145832_p();
    }

    @Override
    public void setMetaValue(int meta) {
        this.field_145850_b.func_72921_c(this.xi(), this.yi(), this.zi(), meta, 3);
    }

    @Override
    public boolean canAccessWorld() {
        return true;
    }

    @Override
    public boolean isRedstonePowered() {
        return this.field_145850_b.func_72864_z(this.xi(), this.yi(), this.zi());
    }

    @Override
    public int getRedstoneLevel() {
        return this.field_145850_b.func_94572_D(this.xi(), this.yi(), this.zi());
    }

    @Override
    public List<ITileEventListener> getListeners(String key) {
        if (this.listeners.containsKey(key)) {
            return this.listeners.get(key);
        }
        return null;
    }

    public void addListener(ITileEventListener listener) {
        List<String> keys = listener.getListenerKeys();
        if (keys != null && !keys.isEmpty()) {
            for (String key : keys) {
                List<ITileEventListener> list = this.listeners.get(key);
                if (list == null) {
                    list = new ArrayList<ITileEventListener>();
                }
                list.add(listener);
                this.listeners.put(key, list);
            }
        }
    }

    @Override
    public String getUniqueID() {
        return this.getTileNode().getUniqueID();
    }

    @Override
    public String contentType() {
        return this.getTileNode().contentType();
    }

    @Override
    public String getMod() {
        return this.getTileNode().getMod();
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        for (List list : this.getMultiTileListeners("renderBounds")) {
            if (list == null || list.isEmpty()) continue;
            for (ITileEventListener listener : list) {
                Cube cube;
                if (!(listener instanceof IRenderBoundsListener)) continue;
                if (listener instanceof IBlockListener) {
                    ((IBlockListener)((Object)listener)).inject(this.world(), this.xi(), this.yi(), this.zi());
                }
                if (!listener.isValidForTile() || (cube = ((IRenderBoundsListener)listener).getRenderBounds()) == null || !cube.isValid()) continue;
                return cube.clone().add(this.xi(), this.yi(), this.zi()).toAABB();
            }
        }
        if (this.renderBoundCache == null) {
            this.renderBoundCache = this.getHostBlock().data.getRenderBounds().clone().add(this.xi(), this.yi(), this.zi()).toAABB();
        }
        return this.renderBoundCache;
    }

    protected List[] getMultiTileListeners(String key) {
        if (!(this.func_145838_q() instanceof BlockBase)) {
            return new List[]{this.getListeners(key)};
        }
        return new List[]{this.getListeners(key), ((BlockBase)this.func_145838_q()).listeners.get(key)};
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClassDisplayName());
        builder.append("(");
        this.toStringData(builder);
        builder.append(")@");
        builder.append(this.hashCode());
        return builder.toString();
    }

    protected String getClassDisplayName() {
        return "TileEntityWrapper";
    }

    protected void toStringData(StringBuilder builder) {
        if (Engine.minecraft != null) {
            if (this.world() != null) {
                if (this.world().isClient()) {
                    builder.append("client, ");
                } else {
                    builder.append("server, ");
                }
            }
            builder.append("world = ");
            if (this.world() != null) {
                builder.append("dim@");
                builder.append(this.world().getDimID());
                builder.append(", ");
            } else {
                builder.append("null, ");
            }
            builder.append(this.xi());
            builder.append("x, ");
            builder.append(this.yi());
            builder.append("y, ");
            builder.append(this.zi());
            builder.append("z, ");
        } else {
            builder.append(" <dead tile> ");
        }
        builder.append("tile = ");
        builder.append(this.getTileNode());
    }

    @Override
    public IWorld world() {
        if (this._worldCache == null && this.field_145850_b != null) {
            this._worldCache = Engine.getWorld(this.field_145850_b.field_73011_w.field_76574_g);
        }
        return this._worldCache;
    }

    public double x() {
        return (double)this.field_145851_c + 0.5;
    }

    public double y() {
        return (double)this.field_145848_d + 0.5;
    }

    public double z() {
        return (double)this.field_145849_e + 0.5;
    }

    public int xi() {
        return this.field_145851_c;
    }

    public int yi() {
        return this.field_145848_d;
    }

    public int zi() {
        return this.field_145849_e;
    }

    public float xf() {
        return (float)this.field_145851_c + 0.5f;
    }

    public float yf() {
        return (float)this.field_145848_d + 0.5f;
    }

    public float zf() {
        return (float)this.field_145849_e + 0.5f;
    }
}

