/*
 * Decompiled with CFR 0.152.
 */
package mal.lootbags;

import cpw.mods.fml.common.FMLLog;
import java.util.ArrayList;
import mal.lootbags.LootBags;
import mal.lootbags.loot.LootItem;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import org.apache.logging.log4j.Level;

public class LootbagsUtil {
    public static void LogError(String message) {
        FMLLog.log((Level)Level.ERROR, (String)("[LOOTBAGS]: " + message), (Object[])new Object[0]);
    }

    public static void LogError(String message, ICommandSender icommand) {
        LootbagsUtil.LogError(message);
        if (icommand != null) {
            icommand.func_145747_a((IChatComponent)new ChatComponentText(message));
        }
    }

    public static void LogInfo(String message) {
        FMLLog.log((Level)Level.INFO, (String)("[LOOTBAGS]: " + message), (Object[])new Object[0]);
    }

    public static ArrayList<Integer> constructDamageRange(String word) {
        int i;
        ArrayList<Integer> damages = new ArrayList<Integer>();
        String[] sec = word.split("[#&]");
        if (sec.length == 1) {
            try {
                damages.add(Integer.parseInt(sec[0]));
            }
            catch (Exception e) {
                LootbagsUtil.LogError("Cannot construct a damage range that doesn't follow the correct syntax.");
                return null;
            }
            return damages;
        }
        int wordindex = 0;
        for (i = 0; i < sec.length - 1; ++i) {
            wordindex += sec[i].length();
            try {
                int num1 = Integer.parseInt(sec[i]);
                int num2 = Integer.parseInt(sec[i + 1]);
                if (word.substring(wordindex, wordindex + 1).equalsIgnoreCase("#")) {
                    damages.add(num1);
                    damages.add(num2);
                } else if (word.substring(wordindex, wordindex + 1).equalsIgnoreCase("&")) {
                    if (num2 < num1) {
                        int t = num1;
                        num1 = num2;
                        num2 = t;
                    }
                    for (int j = num1; j <= num2; ++j) {
                        damages.add(j);
                    }
                }
                ++wordindex;
                continue;
            }
            catch (Exception e) {
                LootbagsUtil.LogError("Cannot construct a damage range that doesn't follow the correct syntax.");
                return null;
            }
        }
        for (i = 1; i < damages.size(); ++i) {
            for (int j = i; j > 1 && damages.get(j) < damages.get(j - 1); --j) {
                int temp = damages.get(j);
                damages.set(j, damages.get(j - 1));
                damages.set(j - 1, temp);
            }
        }
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i2 = 0; i2 < damages.size(); ++i2) {
            if (ret.contains(damages.get(i2))) continue;
            ret.add(damages.get(i2));
        }
        return ret;
    }

    public static byte[] parseNBTArray(String array) {
        String[] sec = array.split("\\|");
        byte[] nbt = new byte[sec.length];
        for (int i = 0; i < nbt.length; ++i) {
            nbt[i] = Byte.parseByte(sec[i]);
        }
        return nbt;
    }

    public static ArrayList<String> addLineBreaks(String input) {
        return LootbagsUtil.addLineBreaks(input, "");
    }

    public static ArrayList<String> addLineBreaks(String input, String pretext) {
        int MAXLENGTH = 40;
        String APPEND = "|";
        String SPACE = " ";
        String[] tokens = input.split("\\s+");
        StringBuilder output = new StringBuilder(input.length());
        int len = 0;
        for (int i = 0; i < tokens.length; ++i) {
            String word = tokens[i];
            if (len + (SPACE + word).length() > MAXLENGTH) {
                if (i > 0) {
                    output.append(APPEND);
                }
                len = 0;
            }
            if (i < tokens.length - 1 && len + (word + SPACE).length() + tokens[i + 1].length() <= MAXLENGTH) {
                word = word + SPACE;
            }
            output.append(word);
            len += word.length();
        }
        String[] list = output.toString().split("\\|");
        ArrayList<String> ret = new ArrayList<String>();
        for (int i = 0; i < list.length; ++i) {
            ret.add(pretext + list[i]);
        }
        return ret;
    }

    public static boolean listContainsItem(ArrayList<LootItem> list, LootItem item) {
        for (LootItem loot : list) {
            if (!LootBags.areItemStacksEqualItem(loot.getContentItem().field_76297_b, item.getContentItem().field_76297_b, true, false)) continue;
            return true;
        }
        return false;
    }
}

