/*
 * Decompiled with CFR 0.152.
 */
package com.builtbroken.jlib.profiler;

import com.builtbroken.jlib.lang.StringHelpers;
import com.builtbroken.jlib.profiler.TimeSpan;
import java.util.HashMap;
import java.util.Map;

public class RunProfile {
    public String name;
    public boolean enabled = System.getProperty("runProfiler") != null && System.getProperty("runProfiler").equalsIgnoreCase("true");
    public HashMap<String, TimeSpan> times = new HashMap();
    protected int maxNameLength = 0;

    public RunProfile(String name) {
        this.name = name;
    }

    public void startSection(String name) {
        if (this.enabled) {
            if (name.length() > this.maxNameLength) {
                this.maxNameLength = name.length();
            }
            this.times.put(name, new TimeSpan(System.nanoTime()));
        }
    }

    public void endSection(String name) {
        if (this.enabled && this.times.containsKey(name)) {
            this.times.get((Object)name).end = System.nanoTime();
        }
    }

    public StringBuilder getOutputSimple() {
        StringBuilder string = new StringBuilder();
        String head = "=== " + this.name + " ===";
        string.append(head + "\n");
        this.addRunData(string);
        string.append("\n\n");
        for (Map.Entry<String, TimeSpan> section : this.times.entrySet()) {
            string.append(StringHelpers.padRight(section.getKey() + ":", this.maxNameLength + 2) + StringHelpers.formatNanoTime(section.getValue().getDelta()) + "\n");
        }
        String end = StringHelpers.padLeft("", head.length()).replace(" ", "=");
        string.append(end + "\n");
        return string;
    }

    public void addRunData(StringBuilder string) {
    }
}

