/*
 * Decompiled with CFR 0.152.
 */
package com.temportalist.origin.screwdriver.api;

import com.temportalist.origin.api.client.utility.Rendering;
import com.temportalist.origin.screwdriver.api.ApiOriginScrewdriver;
import com.temportalist.origin.screwdriver.api.BehaviorType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import scala.Tuple2;

public abstract class Behavior {
    private final String name;
    private final boolean isDefault;

    public Behavior(String name) {
        this(name, false);
    }

    public Behavior(String name, boolean isDefaultBehavior) {
        this.name = name;
        this.isDefault = isDefaultBehavior;
    }

    public int register() {
        return ApiOriginScrewdriver.registerBehavior(this);
    }

    public String getName() {
        return this.name;
    }

    public boolean isDefaultBehavior() {
        return this.isDefault;
    }

    public int getGlobalID() {
        return ApiOriginScrewdriver.getBehaviorGlobalID(this.getName());
    }

    public void postInit() {
    }

    public abstract BehaviorType getBehaviorType();

    public abstract boolean isValidStackForSimulation(ItemStack var1);

    public boolean itemInteractionForEntity(ItemStack container, ItemStack source, EntityPlayer player, EntityLivingBase entity) {
        return false;
    }

    public boolean onBlockStartBreak(ItemStack container, ItemStack source, int x, int y, int z, EntityPlayer player) {
        return false;
    }

    public boolean onItemUseFirst(ItemStack container, ItemStack source, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        return false;
    }

    public void getBehaviorToolClasses(ItemStack container, ItemStack source, Set<String> toolClasses) {
        if (!this.isDefaultBehavior()) {
            toolClasses.addAll(source.func_77973_b().getToolClasses(source));
        }
    }

    public ItemStack onItemRightClick(ItemStack container, ItemStack source, World world, EntityPlayer player) {
        return source;
    }

    public int getMaxItemUseDuration(ItemStack container, ItemStack source) {
        return 0;
    }

    public EnumAction getItemUseAction(ItemStack container, ItemStack source) {
        return EnumAction.none;
    }

    public void onUsingTick(ItemStack container, ItemStack source, EntityPlayer player, int count) {
    }

    public void onPlayerStoppedUsing(ItemStack container, ItemStack source, World world, EntityPlayer player, int itemInUseCount) {
    }

    @SideOnly(value=Side.CLIENT)
    protected abstract ResourceLocation getTexture();

    protected int getTextureSize() {
        return 16;
    }

    @SideOnly(value=Side.CLIENT)
    public void draw(Minecraft mc, double x, double y, double z, double w, double h, boolean renderText) {
        GL11.glPushMatrix();
        Rendering.bindResource(this.getTexture());
        double iconScale = w / (double)this.getTextureSize();
        Rendering.drawTexture((Tuple2<Object, Object>)new Tuple2((Object)((int)x), (Object)((int)y)), (Tuple2<Object, Object>)new Tuple2((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)), (Tuple2<Object, Object>)new Tuple2((Object)MathHelper.func_76128_c((double)((double)this.getTextureSize() * iconScale)), (Object)MathHelper.func_76128_c((double)((double)this.getTextureSize() * iconScale))), (Tuple2<Object, Object>)new Tuple2((Object)Float.valueOf((float)w), (Object)Float.valueOf((float)h)));
        GL11.glPopMatrix();
        if (renderText) {
            GL11.glPushMatrix();
            float scale = 0.5f;
            float aScale = 1.0f / scale;
            GL11.glScaled((double)scale, (double)scale, (double)scale);
            mc.field_71466_p.func_78261_a(this.name, (int)((x + w / 2.0) * (double)aScale) - (int)((float)mc.field_71466_p.func_78256_a(this.name) / 2.0f), (int)((y + h) * (double)aScale) + 2, 0xFFFFFF);
            GL11.glPopMatrix();
        }
    }

    public boolean onSelection(EntityPlayer player) {
        return true;
    }

    public void addInformationOnHover(List<String> hoverInfo) {
        hoverInfo.add(this.getName());
    }
}

