/*
 * Decompiled with CFR 0.152.
 */
package wtfcore.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.BiomeDictionary;

public class AddCustomOre {
    public static Random random = new Random();
    public Block oreBlock;
    public int metadata = 0;
    public String textureName;
    public int genType = 0;
    public HashMap<BiomeDictionary.Type, Float> biomeModifier = new HashMap();
    public HashSet<Integer> dimension = new HashSet();
    public HashSet<String> stoneTypes = new HashSet();
    private float maxHeightPercent = 100.0f;
    private float minHeightPercent = 0.0f;
    private int maxPerChunk = -1;
    private int minPerChunk = -1;
    public int var1 = 5;
    public int var2 = 5;

    public void setMaxHeightPercent(int var) {
        this.maxHeightPercent = (float)var / 100.0f;
    }

    public void setMinHeightPercent(int var) {
        this.minHeightPercent = (float)var / 100.0f;
    }

    public void setMaxPerChunk(int var) {
        this.maxPerChunk = var;
    }

    public void setMinPerChunk(int var) {
        this.minPerChunk = var;
    }

    public int getPerChunk(BiomeDictionary.Type[] biome) {
        int genNumber = this.maxPerChunk == -1 ? this.minPerChunk : (this.minPerChunk == -1 ? this.maxPerChunk : random.nextInt(this.maxPerChunk - this.minPerChunk) + this.minPerChunk);
        for (int loop = 0; loop < biome.length; ++loop) {
            if (!this.biomeModifier.containsKey(biome[loop])) continue;
            genNumber = (int)((float)genNumber * this.biomeModifier.get(biome[loop]).floatValue());
        }
        return genNumber;
    }

    public int getHeight(int surface) {
        int maxHeight = MathHelper.func_76141_d((float)(this.maxHeightPercent * (float)surface));
        int minHeight = MathHelper.func_76141_d((float)(this.minHeightPercent * (float)surface));
        return random.nextInt(maxHeight - minHeight) + minHeight;
    }

    public void setVar1(int var) {
        this.var1 = var;
    }

    public void setVar2(int var) {
        this.var2 = var;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.biomeModifier == null ? 0 : this.biomeModifier.hashCode());
        result = 31 * result + (this.dimension == null ? 0 : this.dimension.hashCode());
        result = 31 * result + this.genType;
        result = 31 * result + Float.floatToIntBits(this.maxHeightPercent);
        result = 31 * result + this.maxPerChunk;
        result = 31 * result + this.metadata;
        result = 31 * result + Float.floatToIntBits(this.minHeightPercent);
        result = 31 * result + this.minPerChunk;
        result = 31 * result + (this.oreBlock == null ? 0 : this.oreBlock.hashCode());
        result = 31 * result + (this.stoneTypes == null ? 0 : this.stoneTypes.hashCode());
        result = 31 * result + (this.textureName == null ? 0 : this.textureName.hashCode());
        result = 31 * result + this.var1;
        result = 31 * result + this.var2;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AddCustomOre other = (AddCustomOre)obj;
        if (this.biomeModifier == null ? other.biomeModifier != null : !this.biomeModifier.equals(other.biomeModifier)) {
            return false;
        }
        if (this.dimension == null ? other.dimension != null : !this.dimension.equals(other.dimension)) {
            return false;
        }
        if (this.genType != other.genType) {
            return false;
        }
        if (Float.floatToIntBits(this.maxHeightPercent) != Float.floatToIntBits(other.maxHeightPercent)) {
            return false;
        }
        if (this.maxPerChunk != other.maxPerChunk) {
            return false;
        }
        if (this.metadata != other.metadata) {
            return false;
        }
        if (Float.floatToIntBits(this.minHeightPercent) != Float.floatToIntBits(other.minHeightPercent)) {
            return false;
        }
        if (this.minPerChunk != other.minPerChunk) {
            return false;
        }
        if (this.oreBlock == null ? other.oreBlock != null : !this.oreBlock.equals(other.oreBlock)) {
            return false;
        }
        if (this.stoneTypes == null ? other.stoneTypes != null : !this.stoneTypes.equals(other.stoneTypes)) {
            return false;
        }
        if (this.textureName == null ? other.textureName != null : !this.textureName.equals(other.textureName)) {
            return false;
        }
        if (this.var1 != other.var1) {
            return false;
        }
        return this.var2 == other.var2;
    }
}

