/*
 * Decompiled with CFR 0.152.
 */
package wtfcore.blocks;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class OreChildBlock
extends Block {
    public Block oreBlock;
    public int oreMeta;
    protected String oreType;
    protected Block stoneBlock;
    protected int oreLevel;
    protected String[] textureNames;
    protected String[] parentLocations;
    protected String[] localizedNames;
    private boolean shouldFall;

    protected OreChildBlock(Block block, int meta, Block stoneBlock) {
        super(stoneBlock.func_149688_o());
        this.oreBlock = block;
        this.oreMeta = meta;
        this.stoneBlock = stoneBlock;
        this.func_149672_a(stoneBlock.field_149762_H);
        if (stoneBlock == Blocks.field_150354_m || stoneBlock == Blocks.field_150351_n) {
            this.shouldFall = true;
        }
    }

    public float func_149712_f(World world, int x, int y, int z) {
        return 2.0f * this.stoneBlock.func_149712_f(world, x, y, z);
    }

    public String getHarvestTool(int metadata) {
        return this.stoneBlock.getHarvestTool(metadata);
    }

    public int getHarvestLevel(int metadata) {
        return this.oreBlock.getHarvestLevel(this.oreMeta);
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (this.oreBlock == Blocks.field_150365_q) {
            return true;
        }
        return this.oreBlock.getFlammability(world, x, y, z, face) > 0;
    }

    public int getFireSpreadSpeed(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (this.oreBlock == Blocks.field_150365_q) {
            return Blocks.field_150364_r.getFireSpreadSpeed(world, x, y, z, face);
        }
        return this.oreBlock.getFireSpreadSpeed(world, x, y, z, face);
    }

    public int getFlammability(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        if (this.oreBlock == Blocks.field_150365_q) {
            return Blocks.field_150364_r.getFlammability(world, x, y, z, face);
        }
        return Blocks.field_150480_ab.getFlammability((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List list) {
        for (int i = 0; i < this.textureNames.length; ++i) {
            list.add(new ItemStack(item, 1, i));
        }
    }

    public int func_149645_b() {
        return 0;
    }

    public void func_149726_b(World world, int x, int y, int z) {
        if (this.shouldFall) {
            world.func_147464_a(x, y, z, (Block)this, 2);
        }
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        if (this.shouldFall) {
            world.func_147464_a(x, y, z, (Block)this, 2);
        }
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        if (this.shouldFall && !world.field_72995_K) {
            this.dropBlock(world, x, y, z);
        }
    }

    private void dropBlock(World world, int x, int y, int z) {
        if (OreChildBlock.func_149831_e(world, x, y - 1, z) && y >= 0) {
            int b0 = 32;
            if (world.func_72904_c(x - b0, y - b0, z - b0, x + b0, y + b0, z + b0)) {
                if (!world.field_72995_K) {
                    EntityFallingBlock entityfallingblock = new EntityFallingBlock(world, (double)((float)x + 0.5f), (double)((float)y + 0.5f), (double)((float)z + 0.5f), (Block)this, world.func_72805_g(x, y, z));
                    this.func_149829_a(entityfallingblock);
                    world.func_72838_d((Entity)entityfallingblock);
                }
            } else {
                world.func_147468_f(x, y, z);
                while (OreChildBlock.func_149831_e(world, x, y - 1, z) && y > 0) {
                    --y;
                }
                if (y > 0) {
                    world.func_147449_b(x, y, z, (Block)this);
                }
            }
        }
    }

    protected void func_149829_a(EntityFallingBlock p_149829_1_) {
    }

    public static boolean func_149831_e(World world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block.isAir((IBlockAccess)world, x, y, z)) {
            return true;
        }
        if (block == Blocks.field_150480_ab) {
            return true;
        }
        Material material = block.func_149688_o();
        return material == Material.field_151586_h ? true : material == Material.field_151587_i;
    }

    public void func_149828_a(World p_149828_1_, int p_149828_2_, int p_149828_3_, int p_149828_4_, int p_149828_5_) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int p_149691_1_, int p_149691_2_) {
        return this.oreBlock.func_149691_a(p_149691_1_, this.oreMeta);
    }

    public boolean func_149662_c() {
        return true;
    }

    public boolean func_149686_d() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149701_w() {
        return this.oreBlock.func_149701_w();
    }

    public Item func_149650_a(int metadata, Random random, int fortune) {
        return this.oreBlock.func_149650_a(this.oreMeta, random, fortune);
    }

    public void func_149749_a(World p_149749_1_, int p_149749_2_, int p_149749_3_, int p_149749_4_, Block p_149749_5_, int p_149749_6_) {
        this.oreBlock.func_149749_a(p_149749_1_, p_149749_2_, p_149749_3_, p_149749_4_, p_149749_5_, this.oreMeta);
    }

    public void func_149657_c(World p_149657_1_, int p_149657_2_, int p_149657_3_, int p_149657_4_, int p_149657_5_) {
        this.oreBlock.func_149657_c(p_149657_1_, p_149657_2_, p_149657_3_, p_149657_4_, p_149657_5_);
    }

    public float func_149638_a(Entity p_149638_1_) {
        return this.oreBlock.func_149638_a(p_149638_1_);
    }

    public boolean canHarvestBlock(EntityPlayer player, int meta) {
        ItemStack currentItem = player.field_71071_by.func_70448_g();
        String reqTool = this.stoneBlock.getHarvestTool(meta);
        if (currentItem == null || reqTool == null) {
            return player.func_146099_a(this.oreBlock);
        }
        int toolLevel = currentItem.func_77973_b().getHarvestLevel(currentItem, reqTool);
        if (toolLevel < 0) {
            return player.func_146099_a(this.oreBlock);
        }
        return toolLevel >= this.oreBlock.getHarvestLevel(meta);
    }

    public void func_149636_a(World p_149636_1_, EntityPlayer p_149636_2_, int p_149636_3_, int p_149636_4_, int p_149636_5_, int p_149636_6_) {
        this.oreBlock.func_149636_a(p_149636_1_, p_149636_2_, p_149636_3_, p_149636_4_, p_149636_5_, this.oreMeta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iconRegister) {
        this.oreBlock.func_149651_a(iconRegister);
    }

    public int func_149692_a(int metadata) {
        return this.oreBlock.func_149692_a(this.oreMeta);
    }

    public boolean canRenderInPass(int pass) {
        return this.oreBlock.canRenderInPass(pass);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149635_D() {
        return this.oreBlock.func_149635_D();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149741_i(int p_149741_1_) {
        return this.oreBlock.func_149635_D();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess p_149720_1_, int p_149720_2_, int p_149720_3_, int p_149720_4_) {
        return this.oreBlock.func_149720_d(p_149720_1_, p_149720_2_, p_149720_3_, p_149720_4_);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149677_c(IBlockAccess p_149677_1_, int p_149677_2_, int p_149677_3_, int p_149677_4_) {
        return this.oreBlock.func_149677_c(p_149677_1_, p_149677_2_, p_149677_3_, p_149677_4_);
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        return this.func_149750_m();
    }

    public boolean isToolEffective(String type, int metadata) {
        return this.stoneBlock.isToolEffective(type, metadata);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149734_b(World world, int x, int y, int z, Random random) {
        this.oreBlock.func_149734_b(world, x, y, z, random);
    }
}

