/*
 * Decompiled with CFR 0.152.
 */
package wtfcore.loader;

import wtfcore.loader.AbstractResolvable;
import wtfcore.loader.Namespace;

public class ClassRef
extends AbstractResolvable<Class<?>> {
    public static final ClassRef INT = ClassRef.primitive("I", Integer.TYPE);
    public static final ClassRef FLOAT = ClassRef.primitive("F", Float.TYPE);
    public static final ClassRef BOOLEAN = ClassRef.primitive("Z", Boolean.TYPE);
    public static final ClassRef VOID = ClassRef.primitive("V", Void.class);
    public boolean isPrimitive = false;
    public String mcpName;
    public String obfName;

    public ClassRef(String mcpName, String obfName) {
        this.mcpName = mcpName;
        this.obfName = obfName;
    }

    public ClassRef(String mcpName) {
        this(mcpName, mcpName);
    }

    protected static ClassRef primitive(String name, Class<?> classObj) {
        ClassRef result = new ClassRef(name);
        result.isPrimitive = true;
        result.resolvedObj = classObj;
        result.isResolved = true;
        return result;
    }

    public String getName(Namespace ns) {
        return ns == Namespace.OBF ? this.obfName : this.mcpName;
    }

    public String getAsmDescriptor(Namespace ns) {
        return this.isPrimitive ? this.mcpName : "L" + this.getName(ns).replace(".", "/") + ";";
    }

    protected Class<?> resolveInternal() {
        try {
            return Class.forName(this.mcpName);
        }
        catch (ClassNotFoundException e) {
            try {
                return Class.forName(this.obfName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }
    }
}

