/*
 * Decompiled with CFR 0.152.
 */
package wtfcore.loader;

import java.lang.reflect.Field;
import wtfcore.loader.AbstractResolvable;
import wtfcore.loader.ClassRef;
import wtfcore.loader.Namespace;

public class FieldRef
extends AbstractResolvable<Field> {
    public ClassRef parent;
    public String mcpName;
    public String srgName;
    public String obfName;
    public ClassRef type;

    public FieldRef(ClassRef parent, String mcpName, String srgName, String obfName, ClassRef returnType) {
        this.parent = parent;
        this.mcpName = mcpName;
        this.srgName = srgName;
        this.obfName = obfName;
        this.type = returnType;
    }

    public FieldRef(ClassRef parent, String mcpName, ClassRef returnType) {
        this(parent, mcpName, mcpName, mcpName, returnType);
    }

    public String getName(Namespace ns) {
        if (ns == Namespace.OBF) {
            return this.obfName;
        }
        if (ns == Namespace.SRG) {
            return this.srgName;
        }
        return this.mcpName;
    }

    public String getAsmDescriptor(Namespace ns) {
        return this.type.getAsmDescriptor(ns);
    }

    public Field resolveInternal() {
        Class parentClass = (Class)this.parent.resolve();
        if (parentClass == null) {
            return null;
        }
        Field fieldObj = null;
        try {
            fieldObj = parentClass.getDeclaredField(this.srgName);
            fieldObj.setAccessible(true);
            return fieldObj;
        }
        catch (Exception e) {
            try {
                fieldObj = parentClass.getDeclaredField(this.mcpName);
                fieldObj.setAccessible(true);
                return fieldObj;
            }
            catch (Exception exception) {
                return fieldObj;
            }
        }
    }

    public <T> T getInstanceField(Object instance) {
        if (this.resolve() == null) {
            return null;
        }
        try {
            Object result = ((Field)this.resolve()).get(instance);
            return (T)result;
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> T getStaticField() {
        return this.getInstanceField(null);
    }
}

