/*
 * Decompiled with CFR 0.152.
 */
package wtfcore.loader;

import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.LinkedList;
import wtfcore.loader.AbstractResolvable;
import wtfcore.loader.ClassRef;
import wtfcore.loader.Namespace;

public class MethodRef
extends AbstractResolvable<Method> {
    public ClassRef parent;
    public String mcpName;
    public String srgName;
    public String obfName;
    public ClassRef returnType;
    public ClassRef[] argTypes;

    public MethodRef(ClassRef parent, String mcpName, String srgName, String obfName, ClassRef returnType, ClassRef ... argTypes) {
        this.parent = parent;
        this.mcpName = mcpName;
        this.srgName = srgName;
        this.obfName = obfName;
        this.returnType = returnType;
        this.argTypes = argTypes;
    }

    public MethodRef(ClassRef parent, String mcpName, ClassRef returnType, ClassRef ... argTypes) {
        this(parent, mcpName, mcpName, mcpName, returnType, argTypes);
    }

    public String getName(Namespace type) {
        if (type == Namespace.OBF) {
            return this.obfName;
        }
        if (type == Namespace.SRG) {
            return this.srgName;
        }
        return this.mcpName;
    }

    public String getAsmDescriptor(Namespace nameType) {
        StringBuilder sb = new StringBuilder("(");
        for (ClassRef arg : this.argTypes) {
            sb.append(arg.getAsmDescriptor(nameType));
        }
        sb.append(")");
        sb.append(this.returnType.getAsmDescriptor(nameType));
        return sb.toString();
    }

    public Method resolveInternal() {
        Class parentClass = (Class)this.parent.resolve();
        if (parentClass == null) {
            return null;
        }
        LinkedList argClasses = Lists.newLinkedList();
        for (ClassRef argType : this.argTypes) {
            if (argType.resolve() == null) {
                return null;
            }
            argClasses.add(argType.resolve());
        }
        Class[] args = argClasses.toArray(new Class[0]);
        try {
            Method methodObj = parentClass.getDeclaredMethod(this.srgName, args);
            methodObj.setAccessible(true);
            return methodObj;
        }
        catch (Exception e) {
            try {
                Method methodObj = parentClass.getDeclaredMethod(this.mcpName, args);
                methodObj.setAccessible(true);
                return methodObj;
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    public <T> T invokeInstanceMethod(Object instance, Object ... args) {
        if (this.resolve() == null) {
            return null;
        }
        try {
            return (T)((Method)this.resolvedObj).invoke(instance, args);
        }
        catch (Exception e) {
            return null;
        }
    }

    public <T> T invokeStaticMethod(Object ... args) {
        return this.invokeInstanceMethod(null, args);
    }
}

