/*
 * Decompiled with CFR 0.152.
 */
package wtfcore.worldgen;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import wtfcore.api.BlockSets;
import wtfcore.worldgen.IWorldScanner;
import wtfcore.worldgen.WorldGenListener;

public class OverworldScanner
implements IWorldScanner {
    @Override
    public void generate(World world, Random rand, int chunkX, int chunkZ) {
        int lastY = 70;
        Chunk chunk = world.func_72938_d(chunkX, chunkZ);
        int surfaceaverage = 0;
        for (int xloop = 0; xloop < 16; ++xloop) {
            int x = chunkX + xloop;
            for (int zloop = 0; zloop < 16; ++zloop) {
                int y;
                int z = chunkZ + zloop;
                lastY = y = this.scanForSurface(chunk, x, lastY, z);
                surfaceaverage += y;
            }
        }
        if ((surfaceaverage /= 256) < 64) {
            surfaceaverage = 64;
        }
        if (WorldGenListener.generator != null) {
            WorldGenListener.generator.generate(world, surfaceaverage, chunkX, chunkZ, rand, null);
        }
    }

    public int scanForSurface(Chunk chunk, int x, int y, int z) {
        while (!chunk.func_76619_d(x & 0xF, y, z & 0xF) && y < 256) {
            y += 10;
        }
        while (this.isAirAndCheck(chunk, x, y, z) && y > 40) {
            --y;
        }
        while (!this.isSurfaceAndCheck(chunk, x, y, z) && y > 40) {
            --y;
        }
        return y;
    }

    public boolean isAirAndCheck(Chunk chunk, int x, int y, int z) {
        Block block = chunk.func_150810_a(x & 0xF, y, z & 0xF);
        if (BlockSets.genReplace.containsKey(block)) {
            return false;
        }
        return block.isAir((IBlockAccess)chunk.field_76637_e, x, y, z);
    }

    public boolean isSurfaceAndCheck(Chunk chunk, int x, int y, int z) {
        Block block = chunk.func_150810_a(x & 0xF, y, z & 0xF);
        if (BlockSets.genReplace.containsKey(block)) {
            // empty if block
        }
        return BlockSets.surfaceBlocks.contains(block);
    }
}

