/*
 * Decompiled with CFR 0.152.
 */
package wtfcore.worldgen;

import java.util.Random;
import net.minecraft.world.World;
import wtfcore.WorldGenListener;
import wtfcore.utilities.BlockSets;

public class WorldScanner {
    public void generateSurface(World world, Random rand, int chunkX, int chunkZ) {
        int lastY = 70;
        int surfaceaverage = 0;
        for (int xloop = 0; xloop < 16; ++xloop) {
            int x = chunkX + xloop;
            for (int zloop = 0; zloop < 16; ++zloop) {
                int y;
                int z = chunkZ + zloop;
                lastY = y = this.scanForSurface(world, x, lastY, z);
                surfaceaverage += y;
            }
        }
        if ((surfaceaverage /= 256) < 64) {
            surfaceaverage = 64;
        }
        if (WorldGenListener.generator != null) {
            WorldGenListener.generator.generate(world, surfaceaverage, chunkX, chunkZ, rand);
        }
    }

    public int scanForSurface(World world, int x, int y, int z) {
        while (!world.func_72937_j(x, y, z) && y < 256) {
            y += 10;
        }
        while (world.func_147437_c(x, y, z) && y > 50) {
            --y;
        }
        while (!BlockSets.surfaceBlocks.contains(world.func_147439_a(x, y, z)) && y > 50) {
            --y;
        }
        return y;
    }
}

