/*
 * Decompiled with CFR 0.152.
 */
package bre.fpsreducer.config;

import bre.fpsreducer.config.CommonConfig;
import java.io.File;
import net.minecraftforge.common.config.Property;

public class GlobalConfig
extends CommonConfig {
    public boolean debugLog;
    public boolean logInChat;
    public int hudLocation;
    public int hudMarginX;
    public int hudMarginY;
    public int hudColorRed;
    public int hudColorGreen;
    public int hudColorBlue;
    public String hudPreText;
    public int hudReductionColorRed;
    public int hudReductionColorGreen;
    public int hudReductionColorBlue;
    public String hudReductionPreText;
    public double hudScale;
    public boolean enablePerPlayerConfig;
    private Property debugLogProp;
    private Property logInChatProp;
    private Property hudLocationProp;
    private Property hudMarginXProp;
    private Property hudMarginYProp;
    private Property hudColorRedProp;
    private Property hudColorGreenProp;
    private Property hudColorBlueProp;
    private Property hudPreTextProp;
    private Property hudReductionColorRedProp;
    private Property hudReductionColorGreenProp;
    private Property hudReductionColorBlueProp;
    private Property hudReductionPreTextProp;
    private Property hudScaleProp;
    private Property enablePerPlayerConfigProp;

    public GlobalConfig(File configFile) {
        super(configFile);
    }

    @Override
    public void loadConfig() {
        super.loadConfig();
        this.debugLogProp = this.cfg.get("debug", "debugLog", false, "Enable debug log.");
        this.logInChatProp = this.cfg.get("debug", "showLogInChat", false, "Show event log on the game screen.");
        this.hudLocationProp = this.cfg.get("global", "hudLocation", 2, "Display the status and the current FPS at the specified location.\n(0:off, 1:top-left, 2:top-right, 3:bottom-right, 4:bottom-left)");
        this.hudMarginXProp = this.cfg.get("global", "hudMarginX", 2, "X margin of HUD position from the corner of the screen.");
        this.hudMarginYProp = this.cfg.get("global", "hudMarginY", 2, "Y margin of HUD position from the corner of the screen.");
        this.hudColorRedProp = this.cfg.get("global", "hudColorRed", 240, "HUD color red (0-255)", 0, 255);
        this.hudColorGreenProp = this.cfg.get("global", "hudColorGreen", 240, "HUD color green (0-255)", 0, 255);
        this.hudColorBlueProp = this.cfg.get("global", "hudColorBlue", 240, "HUD color blue (0-255)", 0, 255);
        this.hudPreTextProp = this.cfg.get("global", "hudPreText", "FPS: ", "Pre-text of FPS display.");
        this.hudReductionColorRedProp = this.cfg.get("global", "hudReductionColorRed", 0, "Reduced fps HUD color red (0-255)", 0, 255);
        this.hudReductionColorGreenProp = this.cfg.get("global", "hudReductionColorGreen", 255, "Reduced fps HUD color green (0-255)", 0, 255);
        this.hudReductionColorBlueProp = this.cfg.get("global", "hudReductionColorBlue", 0, "Reduced fps HUD color blue (0-255)", 0, 255);
        this.hudReductionPreTextProp = this.cfg.get("global", "hudReductionPreText", "ECO MODE: ", "Pre-text of reduced FPS display.");
        this.hudScaleProp = this.cfg.get("global", "hudScale", 1.0, "HUD scale (default: 1.0)");
        this.enablePerPlayerConfigProp = this.cfg.get("global", "enablePerPlayerConfig", true, "Enable per-player configuration. (Settings in common category)");
        this.debugLog = this.debugLogProp.getBoolean();
        this.logInChat = this.logInChatProp.getBoolean();
        this.hudLocation = this.hudLocationProp.getInt();
        this.hudMarginX = this.hudMarginXProp.getInt();
        this.hudMarginY = this.hudMarginYProp.getInt();
        this.hudColorRed = this.hudColorRedProp.getInt();
        this.hudColorGreen = this.hudColorGreenProp.getInt();
        this.hudColorBlue = this.hudColorBlueProp.getInt();
        this.hudPreText = this.hudPreTextProp.getString();
        this.hudReductionColorRed = this.hudReductionColorRedProp.getInt();
        this.hudReductionColorGreen = this.hudReductionColorGreenProp.getInt();
        this.hudReductionColorBlue = this.hudReductionColorBlueProp.getInt();
        this.hudReductionPreText = this.hudReductionPreTextProp.getString();
        this.hudScale = this.hudScaleProp.getDouble();
        this.enablePerPlayerConfig = this.enablePerPlayerConfigProp.getBoolean();
    }

    @Override
    public void saveConfig() {
        this.debugLogProp.setValue(this.debugLog);
        this.logInChatProp.setValue(this.logInChat);
        this.hudLocationProp.setValue(this.hudLocation);
        this.hudMarginXProp.setValue(this.hudMarginX);
        this.hudMarginYProp.setValue(this.hudMarginY);
        this.hudColorRedProp.setValue(this.hudColorRed);
        this.hudColorGreenProp.setValue(this.hudColorGreen);
        this.hudColorBlueProp.setValue(this.hudColorBlue);
        this.hudPreTextProp.setValue(this.hudPreText);
        this.hudReductionColorRedProp.setValue(this.hudReductionColorRed);
        this.hudReductionColorGreenProp.setValue(this.hudReductionColorGreen);
        this.hudReductionColorBlueProp.setValue(this.hudReductionColorBlue);
        this.hudReductionPreTextProp.setValue(this.hudReductionPreText);
        this.hudScaleProp.setValue(this.hudScale);
        this.enablePerPlayerConfigProp.setValue(this.enablePerPlayerConfig);
        super.saveConfig();
    }

    @Override
    protected void convertVersion() {
        if (this.cfg.getLoadedConfigVersion() == null) {
            if (this.hudMarginX == 1 && this.hudMarginY == 1) {
                this.hudMarginX = 2;
                this.hudMarginY = 2;
            }
            if (this.hudColorRed == 192 && this.hudColorGreen == 192 && this.hudColorBlue == 192) {
                this.hudColorRed = 240;
                this.hudColorGreen = 240;
                this.hudColorBlue = 240;
            }
        }
        this.removeKey("settings", "enableHUD");
        super.convertVersion();
    }
}

