/*
 * Decompiled with CFR 0.152.
 */
package bre.fpsreducer.config;

import bre.fpsreducer.config.CommonConfig;
import bre.fpsreducer.config.GlobalConfig;
import java.io.File;
import net.minecraftforge.common.config.Property;

public class PlayerConfig
extends CommonConfig {
    public static File playerConfigFile;
    public boolean usePlayerConfig;
    private Property usePlayerConfigProp;

    public PlayerConfig(File configFile) {
        super(configFile);
    }

    @Override
    protected void initDefaultValue() {
        GlobalConfig globalConfig = CommonConfig.globalConfig;
        if (globalConfig == null) {
            super.initDefaultValue();
        } else {
            this.enableFpsReducerDefault = globalConfig.enableFpsReducer;
            this.waitingTimeDefault = globalConfig.waitingTime;
            this.idleFPSDefault = globalConfig.idleFPS;
            this.ignoreHoldButtonDefault = globalConfig.ignoreHoldButton;
            this.reducingInBackgroundDefault = globalConfig.reducingInBackground;
            this.suppressSoundDefalut = globalConfig.suppressSound;
            this.suppressedVolumeDefalut = globalConfig.suppressedVolume;
            this.inquireInitSettingDefalut = globalConfig.inquireInitSetting;
        }
    }

    @Override
    public void loadConfig() {
        super.loadConfig();
        this.usePlayerConfigProp = this.cfg.get("per-player", "usePlayerConfig", false, "Use the per-player config file.");
        this.usePlayerConfig = this.usePlayerConfigProp.getBoolean();
    }

    @Override
    public void saveConfig() {
        this.usePlayerConfigProp.setValue(this.usePlayerConfig);
        super.saveConfig();
    }

    public static void doneInitConfig() {
        if (PlayerConfig.isPlayerConfig()) {
            CommonConfig.playerConfig.inquireInitSetting = false;
            CommonConfig.saveCurrentConfig();
        }
    }

    public static void readPlayerConfig() {
        playerConfig = new PlayerConfig(playerConfigFile);
        if (PlayerConfig.playerConfig.usePlayerConfig) {
            currentConfig = playerConfig;
        }
    }
}

