/*
 * Decompiled with CFR 0.152.
 */
package gaia.items;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gaia.Gaia;
import gaia.entity.EntityGaiaEggInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Facing;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public final class ItemGaiaSpawnEgg
extends Item {
    @SideOnly(value=Side.CLIENT)
    private IIcon baseIcon;
    @SideOnly(value=Side.CLIENT)
    private IIcon overlayIcon;
    private static Map<Integer, String> idToName = new HashMap<Integer, String>();
    private static Map<Integer, EntityGaiaEggInfo> idToEgg = new HashMap<Integer, EntityGaiaEggInfo>();
    private static Map<Integer, Class<? extends EntityLiving>> idToClass = new HashMap<Integer, Class<? extends EntityLiving>>();
    private static Map<Class<? extends EntityLiving>, Integer> classToID = new HashMap<Class<? extends EntityLiving>, Integer>();

    public static void registerEntityEgg(Class<? extends EntityLiving> entityClass, int entityID, int primaryColor, int secondaryColor) {
        Integer id = entityID;
        idToClass.put(id, entityClass);
        classToID.put(entityClass, id);
        idToEgg.put(id, new EntityGaiaEggInfo(entityID, primaryColor, secondaryColor));
        idToName.put(id, (String)EntityList.field_75626_c.get(entityClass));
    }

    public static Entity spawnCreature(World world, int entityID, double posX, double posY, double posZ) {
        Integer id = entityID;
        if (!idToEgg.containsKey(id)) {
            return null;
        }
        EntityLiving entity = null;
        try {
            Class<? extends EntityLiving> exception = idToClass.get(id);
            if (exception != null) {
                entity = exception.getConstructor(World.class).newInstance(world);
            }
        }
        catch (Exception var11) {
            var11.printStackTrace();
        }
        if (entity != null) {
            entity.func_70012_b(posX, posY, posZ, MathHelper.func_76142_g((float)(world.field_73012_v.nextFloat() * 360.0f)), 0.0f);
            entity.field_70759_as = entity.field_70177_z;
            entity.field_70761_aq = entity.field_70177_z;
            entity.func_110161_a((IEntityLivingData)null);
            world.func_72838_d((Entity)entity);
            entity.func_70642_aH();
        }
        return entity;
    }

    public static int entityID(Class<? extends EntityLiving> entityClass) {
        Integer result = classToID.get(entityClass);
        return null == result ? -1 : result;
    }

    public ItemGaiaSpawnEgg() {
        this.func_77627_a(true);
        this.func_77637_a(Gaia.tabGaia);
        this.func_77655_b("GrimoireOfGaia.MonsterPlacer");
    }

    public String func_77653_i(ItemStack istack) {
        String ownName = ("" + StatCollector.func_74838_a((String)(this.func_77658_a() + ".name"))).trim();
        String mobName = idToName.get(istack.func_77960_j());
        if (mobName != null) {
            ownName = ownName + " " + StatCollector.func_74838_a((String)("entity." + mobName + ".name"));
        }
        return ownName;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack istack, int renderPass) {
        EntityGaiaEggInfo EntityGaiaEggInfo2 = idToEgg.get(istack.func_77960_j());
        return EntityGaiaEggInfo2 != null ? (renderPass == 0 ? EntityGaiaEggInfo2.primaryColor : EntityGaiaEggInfo2.secondaryColor) : 0xFFFFFF;
    }

    public boolean func_77648_a(ItemStack istack, EntityPlayer player, World world, int posX, int posY, int posZ, int side, float par8, float par9, float par10) {
        Entity entity;
        if (world.field_72995_K) {
            return true;
        }
        Block b = world.func_147439_a(posX, posY, posZ);
        posX += Facing.field_71586_b[side];
        posY += Facing.field_71587_c[side];
        posZ += Facing.field_71585_d[side];
        double verticalOffset = 0.0;
        if (side == 1 && b != Blocks.field_150350_a && b.func_149645_b() == 11) {
            verticalOffset = 0.5;
        }
        if ((entity = ItemGaiaSpawnEgg.spawnCreature(world, istack.func_77960_j(), (double)posX + 0.5, (double)posY + verticalOffset, (double)posZ + 0.5)) != null) {
            if (entity instanceof EntityLiving && istack.func_82837_s()) {
                ((EntityLiving)entity).func_94058_c(istack.func_82833_r());
            }
            if (!player.field_71075_bZ.field_75098_d) {
                --istack.field_77994_a;
            }
        }
        return true;
    }

    public ItemStack func_77659_a(ItemStack istack, World world, EntityPlayer player) {
        if (world.field_72995_K) {
            return istack;
        }
        MovingObjectPosition movingobjectposition = this.func_77621_a(world, player, true);
        if (movingobjectposition == null) {
            return istack;
        }
        if (movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            Entity entity;
            int posX = movingobjectposition.field_72311_b;
            int posY = movingobjectposition.field_72312_c;
            int posZ = movingobjectposition.field_72309_d;
            if (!world.func_72962_a(player, posX, posY, posZ) || !player.func_82247_a(posX, posY, posZ, movingobjectposition.field_72310_e, istack)) {
                return istack;
            }
            Block b = world.func_147439_a(posX, posY, posZ);
            if (b.func_149688_o() == Material.field_151586_h && (entity = ItemGaiaSpawnEgg.spawnCreature(world, istack.func_77960_j(), posX, posY, posZ)) != null) {
                if (entity instanceof EntityLiving && istack.func_82837_s()) {
                    ((EntityLiving)entity).func_94058_c(istack.func_82833_r());
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    --istack.field_77994_a;
                }
            }
        }
        return istack;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77618_c(int damage, int renderPass) {
        return renderPass > 0 ? this.overlayIcon : this.baseIcon;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item p_150895_1_, CreativeTabs p_150895_2_, List p_150895_3_) {
        for (EntityGaiaEggInfo info : idToEgg.values()) {
            p_150895_3_.add(new ItemStack(p_150895_1_, 1, info.spawnedID));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegistry) {
        this.baseIcon = iconRegistry.func_94245_a("spawn_egg");
        this.overlayIcon = iconRegistry.func_94245_a("spawn_egg_overlay");
    }
}

