/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib;

import cpw.mods.fml.relauncher.Side;
import ftb.lib.FTBLib;
import ftb.lib.api.GameMode;
import ftb.lib.api.GameModes;
import java.io.File;
import latmod.lib.ByteIOStream;
import latmod.lib.LMFileUtils;

public class FTBWorld {
    public static FTBWorld server = null;
    public static FTBWorld client = null;
    public final Side side;
    private GameMode currentMode;
    private File currentModeFile = null;
    private File currentWorldIDFile = null;

    public static FTBWorld get(Side s) {
        return s.isServer() ? server : client;
    }

    public FTBWorld(Side sd) {
        this.side = sd;
        if (this.side.isClient()) {
            this.currentMode = new GameMode("default");
        } else {
            this.currentMode = GameModes.getGameModes().defaultMode;
            try {
                this.currentModeFile = new File(FTBLib.folderWorld, "ftb_gamemode.txt");
                this.currentMode = GameModes.getGameModes().get(LMFileUtils.loadAsText(this.currentModeFile).trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            for (GameMode s : GameModes.getGameModes().modes.values()) {
                s.getFolder();
            }
        }
    }

    public GameMode getMode() {
        return this.currentMode;
    }

    public void writeReloadData(ByteIOStream io) {
        io.writeUTF(this.currentMode.getID());
    }

    public void readReloadData(ByteIOStream io) {
        String mode = io.readUTF();
        GameModes.reload();
        this.currentMode = GameModes.getGameModes().get(mode);
    }

    public int setMode(String s) {
        GameMode m = GameModes.getGameModes().modes.get(s);
        if (m == null) {
            return 1;
        }
        if (m.equals(this.currentMode)) {
            return 2;
        }
        this.currentMode = m;
        if (this.side.isServer()) {
            try {
                LMFileUtils.save(this.currentModeFile, this.currentMode.getID());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return 0;
    }
}

