/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api;

import ftb.lib.TextureCoords;
import ftb.lib.api.client.FTBLibClient;
import ftb.lib.api.friends.ILMPlayer;
import ftb.lib.api.gui.GuiLM;
import ftb.lib.mod.FTBLibMod;
import java.util.List;
import latmod.lib.util.FinalIDObject;

public abstract class PlayerAction
extends FinalIDObject {
    public final Type type;
    public final int priority;
    public final TextureCoords icon;

    public PlayerAction(Type t, String id, int p, TextureCoords c) {
        super(id);
        this.type = t == null ? Type.SELF : t;
        this.priority = p;
        this.icon = c;
    }

    public abstract void onClicked(ILMPlayer var1, ILMPlayer var2);

    public String getDisplayName() {
        return FTBLibMod.proxy.translate("player_action." + this.getID(), new Object[0]);
    }

    public void addMouseOverText(List<String> l) {
    }

    public void render(int ax, int ay, double z) {
        FTBLibClient.setTexture(this.icon);
        GuiLM.drawTexturedRectD(ax, ay, z, 16.0, 16.0, this.icon.minU, this.icon.minV, this.icon.maxU, this.icon.maxV);
    }

    public void postRender(int ax, int ay, double z) {
    }

    @Override
    public int compareTo(Object o) {
        int i = Integer.compare(((PlayerAction)o).priority, this.priority);
        return i == 0 ? super.compareTo(o) : i;
    }

    public boolean isVisibleFor(ILMPlayer self, ILMPlayer other) {
        return true;
    }

    public Boolean configDefault() {
        return null;
    }

    public static enum Type {
        SELF,
        OTHER,
        BOTH;


        public boolean self() {
            return this == SELF || this == BOTH;
        }

        public boolean other() {
            return this == OTHER || this == BOTH;
        }

        public boolean equalsType(Type t) {
            if (t == null || t == BOTH) {
                return true;
            }
            if (t == SELF) {
                return this.self();
            }
            return this.other();
        }
    }
}

