/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import ftb.lib.api.config.ConfigEntry;
import ftb.lib.api.config.ConfigType;
import latmod.lib.ByteIOStream;
import latmod.lib.IntList;

public class ConfigEntryIntArray
extends ConfigEntry {
    public final IntList defValue;
    private IntList value = new IntList();

    public ConfigEntryIntArray(String id, IntList def) {
        super(id);
        this.set(def);
        this.defValue = def == null ? new IntList() : def.copy();
    }

    @Override
    public ConfigType getConfigType() {
        return ConfigType.INT_ARRAY;
    }

    @Override
    public int getColor() {
        return 11164392;
    }

    public ConfigEntryIntArray(String id, int[] def) {
        this(id, IntList.asList(def));
    }

    public void set(IntList l) {
        this.value.clear();
        this.value.addAll(l);
    }

    public IntList get() {
        return this.value;
    }

    @Override
    public final void func_152753_a(JsonElement o) {
        JsonArray a = o.getAsJsonArray();
        this.value.clear();
        for (int i = 0; i < a.size(); ++i) {
            this.value.add(a.get(i).getAsInt());
        }
        this.set(this.value.copy());
    }

    @Override
    public final JsonElement func_151003_a() {
        JsonArray a = new JsonArray();
        this.value = this.get();
        for (int i = 0; i < this.value.size(); ++i) {
            a.add((JsonElement)new JsonPrimitive((Number)this.value.get(i)));
        }
        return a;
    }

    @Override
    public void write(ByteIOStream io) {
        this.value = this.get();
        io.writeShort(this.value.size());
        for (int i = 0; i < this.value.size(); ++i) {
            io.writeInt(this.value.get(i));
        }
    }

    @Override
    public void read(ByteIOStream io) {
        this.value.clear();
        int s = io.readUnsignedShort();
        for (int i = 0; i < s; ++i) {
            this.value.add(io.readInt());
        }
        this.set(this.value.copy());
    }

    @Override
    public void writeExtended(ByteIOStream io) {
        this.write(io);
        io.writeShort(this.defValue.size());
        for (int i = 0; i < this.defValue.size(); ++i) {
            io.writeInt(this.defValue.get(i));
        }
    }

    @Override
    public void readExtended(ByteIOStream io) {
        this.read(io);
        this.defValue.clear();
        int s = io.readUnsignedShort();
        for (int i = 0; i < s; ++i) {
            this.defValue.add(io.readInt());
        }
    }

    @Override
    public String getAsString() {
        return this.get().toString();
    }

    @Override
    public String[] getAsStringArray() {
        this.value = this.get();
        String[] s = new String[this.value.size()];
        for (int i = 0; i < s.length; ++i) {
            s[i] = Integer.toString(this.value.get(i));
        }
        return s;
    }

    @Override
    public int[] getAsIntArray() {
        return this.get().toArray();
    }

    @Override
    public double[] getAsDoubleArray() {
        int[] a = this.getAsIntArray();
        if (a == null) {
            return null;
        }
        double[] a1 = new double[a.length];
        for (int i = 0; i < a1.length; ++i) {
            a1[i] = a[i];
        }
        return a1;
    }

    @Override
    public String getDefValueString() {
        return this.defValue.toString();
    }
}

