/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import ftb.lib.api.config.ConfigEntry;
import ftb.lib.api.config.ConfigEntryCustom;
import ftb.lib.api.config.ConfigFile;
import ftb.lib.api.config.ConfigType;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import latmod.lib.ByteIOStream;
import latmod.lib.LMListUtils;
import latmod.lib.LMMapUtils;
import latmod.lib.LMUtils;
import latmod.lib.annotations.AnnotationHelper;

public class ConfigGroup
extends ConfigEntry {
    public final Map<String, ConfigEntry> entryMap = new LinkedHashMap<String, ConfigEntry>();

    public ConfigGroup(String s) {
        super(s);
    }

    @Override
    public ConfigType getConfigType() {
        return ConfigType.GROUP;
    }

    public final List<ConfigEntry> entries() {
        return LMMapUtils.values(this.entryMap, null);
    }

    public ConfigFile getConfigFile() {
        return this.parentGroup != null ? this.parentGroup.getConfigFile() : null;
    }

    public ConfigGroup add(ConfigEntry e, boolean copy) {
        if (e != null) {
            if (copy) {
                ConfigEntry e1 = e.copy();
                this.entryMap.put(e1.getID(), e1);
                e1.parentGroup = this;
            } else {
                this.entryMap.put(e.getID(), e);
                e.parentGroup = this;
            }
        }
        return this;
    }

    public ConfigGroup addAll(Class<?> c, Object parent, boolean copy) {
        try {
            Field[] f = c.getDeclaredFields();
            if (f != null && f.length > 0) {
                for (Field aF : f) {
                    try {
                        ConfigEntry entry;
                        aF.setAccessible(true);
                        if (!ConfigEntry.class.isAssignableFrom(aF.getType()) || (entry = (ConfigEntry)aF.get(parent)) == null || entry == this || entry instanceof ConfigFile) continue;
                        AnnotationHelper.inject(aF, parent, entry);
                        this.add(entry, copy);
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this;
    }

    @Override
    public ConfigEntry copy() {
        ConfigGroup g = new ConfigGroup(this.getID());
        for (ConfigEntry e : this.entryMap.values()) {
            g.add(e, true);
        }
        return g;
    }

    @Override
    public final void func_152753_a(JsonElement o0) {
        if (o0 == null || !o0.isJsonObject()) {
            return;
        }
        this.entryMap.clear();
        JsonObject o = o0.getAsJsonObject();
        for (Map.Entry e : o.entrySet()) {
            ConfigEntryCustom entry = new ConfigEntryCustom((String)e.getKey());
            if (!((JsonElement)e.getValue()).isJsonNull()) {
                ((ConfigEntry)entry).func_152753_a((JsonElement)e.getValue());
                entry.onPostLoaded();
            }
            this.add(entry, false);
        }
    }

    @Override
    public final JsonElement func_151003_a() {
        JsonObject o = new JsonObject();
        for (ConfigEntry e : this.entries()) {
            if (e.getFlag((byte)4)) continue;
            e.onPreLoaded();
            o.add(e.getID(), e.func_151003_a());
        }
        return o;
    }

    @Override
    public String getAsString() {
        return this.func_151003_a().toString();
    }

    @Override
    public String[] getAsStringArray() {
        return LMListUtils.toStringArray(this.entries());
    }

    @Override
    public boolean getAsBoolean() {
        return !this.entryMap.isEmpty();
    }

    @Override
    public int getAsInt() {
        return this.entryMap.size();
    }

    @Override
    public void write(ByteIOStream io) {
        io.writeShort(this.entryMap.size());
        for (ConfigEntry e : this.entryMap.values()) {
            e.onPreLoaded();
            io.writeByte(e.getConfigType().ordinal());
            io.writeUTF(e.getID());
            e.write(io);
        }
    }

    @Override
    public void read(ByteIOStream io) {
        int s = io.readUnsignedShort();
        this.entryMap.clear();
        for (int i = 0; i < s; ++i) {
            int type = io.readUnsignedByte();
            String id = io.readUTF();
            ConfigEntry e = ConfigType.VALUES[type].createNew(id);
            e.read(io);
            this.add(e, false);
        }
    }

    @Override
    public void writeExtended(ByteIOStream io) {
        io.writeShort(this.entryMap.size());
        for (ConfigEntry e : this.entryMap.values()) {
            e.onPreLoaded();
            io.writeByte(e.getConfigType().ordinal());
            io.writeUTF(e.getID());
            e.writeExtended(io);
            String[] info = this.getInfo();
            e.setFlag((byte)5, info != null && info.length > 0);
            io.writeByte(e.flags);
            if (!e.getFlag((byte)5)) continue;
            io.writeByte(info.length);
            for (String s : info) {
                io.writeUTF(s);
            }
        }
    }

    @Override
    public void readExtended(ByteIOStream io) {
        int s = io.readUnsignedShort();
        this.entryMap.clear();
        for (int i = 0; i < s; ++i) {
            int type = io.readUnsignedByte();
            String id = io.readUTF();
            ConfigEntry e = ConfigType.VALUES[type].createNew(id);
            e.readExtended(io);
            e.flags = io.readByte();
            if (e.getFlag((byte)5)) {
                String[] info = new String[io.readUnsignedByte()];
                for (int j = 0; j < info.length; ++j) {
                    info[j] = io.readUTF();
                }
                e.setInfo(info);
            }
            this.add(e, false);
        }
    }

    public int loadFromGroup(ConfigGroup l) {
        if (l == null || l.entryMap.isEmpty()) {
            return 0;
        }
        int result = 0;
        for (ConfigEntry e1 : l.entryMap.values()) {
            ConfigEntry e0 = this.entryMap.get(e1.getID());
            if (e0 == null) continue;
            if (e0.getAsGroup() != null) {
                ConfigGroup g1 = new ConfigGroup(e1.getID());
                g1.func_152753_a(e1.func_151003_a());
                result += e0.getAsGroup().loadFromGroup(g1);
                continue;
            }
            try {
                e0.func_152753_a(e1.func_151003_a());
                e0.onPostLoaded();
                ++result;
            }
            catch (Exception ex) {
                System.err.println("Can't set value " + e1.func_151003_a() + " for '" + e0.parentGroup.getID() + "." + e0.getID() + "' (type:" + (Object)((Object)e0.getConfigType()) + ")");
                System.err.println(ex.toString());
            }
        }
        if (result > 0) {
            this.onLoadedFromGroup(l);
        }
        return result;
    }

    protected void onLoadedFromGroup(ConfigGroup l) {
    }

    public boolean hasKey(Object key) {
        return this.entryMap.containsKey(LMUtils.getID(key));
    }

    public ConfigEntry getEntry(Object key) {
        return this.entryMap.get(LMUtils.getID(key));
    }

    public ConfigGroup getGroup(Object key) {
        ConfigEntry e = this.getEntry(key);
        return e == null ? null : e.getAsGroup();
    }

    public List<ConfigGroup> getGroups() {
        ArrayList<ConfigGroup> list = new ArrayList<ConfigGroup>();
        for (ConfigEntry e : this.entryMap.values()) {
            ConfigGroup g = e.getAsGroup();
            if (g == null) continue;
            list.add(g);
        }
        return list;
    }

    @Override
    public ConfigGroup getAsGroup() {
        return this;
    }

    public int getTotalEntryCount() {
        int count = 0;
        for (ConfigEntry e : this.entryMap.values()) {
            if (e.getAsGroup() == null) {
                ++count;
                continue;
            }
            count += e.getAsGroup().getTotalEntryCount();
        }
        return count;
    }

    public int getDepth() {
        return this.parentGroup == null ? 0 : this.parentGroup.getDepth() + 1;
    }

    public ConfigGroup generateSynced(boolean copy) {
        ConfigGroup out = new ConfigGroup(this.getID());
        for (ConfigEntry e : this.entryMap.values()) {
            if (e.getFlag((byte)0)) {
                out.add(e, copy);
                continue;
            }
            if (e.getAsGroup() == null) continue;
            ConfigGroup g = e.getAsGroup().generateSynced(copy);
            if (g.entryMap.isEmpty()) continue;
            out.add(g, false);
        }
        return out;
    }
}

