/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.config;

import ftb.lib.api.config.ConfigEntry;
import ftb.lib.api.config.ConfigEntryBool;
import ftb.lib.api.config.ConfigEntryColor;
import ftb.lib.api.config.ConfigEntryCustom;
import ftb.lib.api.config.ConfigEntryDouble;
import ftb.lib.api.config.ConfigEntryEnumExtended;
import ftb.lib.api.config.ConfigEntryInt;
import ftb.lib.api.config.ConfigEntryIntArray;
import ftb.lib.api.config.ConfigEntryString;
import ftb.lib.api.config.ConfigEntryStringArray;
import ftb.lib.api.config.ConfigGroup;
import latmod.lib.IntList;
import latmod.lib.LMColor;

public enum ConfigType {
    CUSTOM,
    GROUP,
    BOOLEAN,
    INT,
    DOUBLE,
    STRING,
    ENUM,
    INT_ARRAY,
    STRING_ARRAY,
    COLOR;

    public static final ConfigType[] VALUES;

    public ConfigEntry createNew(String id) {
        switch (this) {
            case CUSTOM: {
                return new ConfigEntryCustom(id);
            }
            case GROUP: {
                return new ConfigGroup(id);
            }
            case BOOLEAN: {
                return new ConfigEntryBool(id, false);
            }
            case INT: {
                return new ConfigEntryInt(id, 0);
            }
            case DOUBLE: {
                return new ConfigEntryDouble(id, 0.0);
            }
            case STRING: {
                return new ConfigEntryString(id, null);
            }
            case ENUM: {
                return new ConfigEntryEnumExtended(id);
            }
            case INT_ARRAY: {
                return new ConfigEntryIntArray(id, (IntList)null);
            }
            case STRING_ARRAY: {
                return new ConfigEntryStringArray(id, new String[0]);
            }
            case COLOR: {
                return new ConfigEntryColor(id, new LMColor.RGB());
            }
        }
        return null;
    }

    public boolean isArray() {
        return this == INT_ARRAY || this == STRING_ARRAY;
    }

    static {
        VALUES = ConfigType.values();
    }
}

