/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.gui;

import ftb.lib.api.PlayerAction;
import ftb.lib.api.config.ConfigEntryBool;
import ftb.lib.api.config.ConfigGroup;
import ftb.lib.api.friends.ILMPlayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class PlayerActionRegistry {
    private static final HashMap<String, PlayerAction> map = new HashMap();
    public static final ConfigGroup configGroup = new ConfigGroup("sidebar_buttons");

    public static boolean enabled(String id) {
        return !PlayerActionRegistry.configGroup.entryMap.containsKey(id) || configGroup.getEntry(id).getAsBoolean();
    }

    public static void add(final PlayerAction a) {
        if (a != null) {
            map.put(a.getID(), a);
            if (a.configDefault() != null) {
                ConfigEntryBool entry = new ConfigEntryBool(a.getID(), a.configDefault()){

                    @Override
                    public String getFullID() {
                        return "player_action." + a.getID();
                    }
                };
                configGroup.add(entry, false);
            }
        }
    }

    public static List<PlayerAction> getPlayerActions(PlayerAction.Type t, ILMPlayer self, ILMPlayer other, boolean sort, boolean ignoreConfig) {
        ArrayList<PlayerAction> l = new ArrayList<PlayerAction>();
        for (PlayerAction a : map.values()) {
            if (!a.type.equalsType(t) || !a.isVisibleFor(self, other) || !ignoreConfig && a.configDefault() != null && !PlayerActionRegistry.enabled(a.getID())) continue;
            l.add(a);
        }
        if (sort) {
            Collections.sort(l);
        }
        return l;
    }
}

