/*
 * Decompiled with CFR 0.152.
 */
package ftb.lib.api.notification;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import ftb.lib.JsonHelper;
import ftb.lib.api.item.ItemStackSerializer;
import ftb.lib.api.notification.MouseAction;
import latmod.lib.LMColorUtils;
import latmod.lib.util.FinalIDObject;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IJsonSerializable;

public final class Notification
extends FinalIDObject
implements IJsonSerializable {
    public IChatComponent title;
    public IChatComponent desc;
    public int timer;
    public int color;
    public ItemStack item;
    public MouseAction mouse;

    public Notification(String s) {
        super(s);
    }

    public Notification(String s, IChatComponent t, int l) {
        super(s);
        this.title = t;
        this.timer = l;
    }

    private void setDefaults() {
        this.title = null;
        this.desc = null;
        this.timer = 3000;
        this.color = -6250336;
        this.item = null;
        this.mouse = null;
    }

    public void setDesc(IChatComponent c) {
        this.desc = c;
    }

    public void setItem(ItemStack is) {
        this.item = is;
    }

    public void setColor(int c) {
        this.color = c;
    }

    public void setMouseAction(MouseAction e) {
        this.mouse = e;
    }

    public boolean isTemp() {
        return this.mouse == null;
    }

    public JsonElement func_151003_a() {
        JsonObject o = new JsonObject();
        o.add("id", (JsonElement)new JsonPrimitive(this.getID()));
        o.add("title", JsonHelper.serializeICC(this.title));
        if (this.timer != 3000) {
            o.add("timer", (JsonElement)new JsonPrimitive((Number)this.timer));
        }
        if (this.desc != null) {
            o.add("desc", JsonHelper.serializeICC(this.desc));
        }
        if (this.item != null) {
            o.add("item", ItemStackSerializer.serialize(this.item));
        }
        if (this.color != -6250336) {
            o.add("color", LMColorUtils.serialize(this.color));
        }
        if (this.mouse != null) {
            o.add("mouse", this.mouse.func_151003_a());
        }
        return o;
    }

    public void func_152753_a(JsonElement e) {
        if (e == null || !e.isJsonObject()) {
            return;
        }
        this.setDefaults();
        JsonObject o = e.getAsJsonObject();
        this.title = JsonHelper.deserializeICC(o.get("title"));
        int n = this.timer = o.has("timer") ? o.get("timer").getAsInt() : 3000;
        if (o.has("desc")) {
            this.setDesc(JsonHelper.deserializeICC(o.get("desc")));
        }
        if (o.has("color")) {
            this.setColor(LMColorUtils.deserialize(o.get("color")));
        }
        if (o.has("item")) {
            this.setItem(ItemStackSerializer.deserialize(o.get("item")));
        }
        if (o.has("mouse")) {
            MouseAction m = new MouseAction();
            m.func_152753_a(o.get("mouse"));
            this.setMouseAction(m);
        }
    }

    @Override
    public String toString() {
        return this.func_151003_a().toString();
    }

    public static Notification deserialize(JsonElement e) {
        if (e == null || !e.isJsonObject()) {
            return null;
        }
        JsonObject o = e.getAsJsonObject();
        if (!o.has("id") || !o.has("title")) {
            return null;
        }
        Notification n = new Notification(o.get("id").getAsString());
        n.func_152753_a((JsonElement)o);
        return n;
    }
}

