/*
 * Decompiled with CFR 0.152.
 */
package latmod.lib;

import com.google.gson.JsonElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import latmod.lib.LMJsonUtils;

public class IntList
implements Iterable<Integer> {
    private int defVal = -1;
    private int[] array;
    private int size;

    public IntList(int i) {
        this.array = new int[i];
    }

    public IntList() {
        this(0);
    }

    public IntList(int[] ai) {
        if (ai != null && ai.length > 0) {
            this.size = ai.length;
            this.array = new int[this.size];
            System.arraycopy(ai, 0, this.array, 0, this.size);
        } else {
            this.size = 0;
            this.array = new int[0];
        }
    }

    public int size() {
        return this.size;
    }

    public void clear() {
        if (this.size > 0) {
            this.size = 0;
            this.array = new int[0];
        }
    }

    public IntList setDefVal(int value) {
        this.defVal = value;
        return this;
    }

    public void expand(int s) {
        if (this.size + s > this.array.length) {
            int[] ai = new int[this.size + Math.max(s, 10)];
            System.arraycopy(this.array, 0, ai, 0, this.size);
            this.array = ai;
        }
    }

    public void add(int value) {
        this.expand(1);
        this.array[this.size] = value;
        ++this.size;
    }

    public void addAll(int ... values) {
        if (values != null && values.length > 0) {
            this.expand(values.length);
            System.arraycopy(values, 0, this.array, this.size, values.length);
            this.size += values.length;
        }
    }

    public void addAll(IntList l) {
        if (l != null && l.size > 0) {
            this.expand(l.size);
            System.arraycopy(l.array, 0, this.array, this.size, l.size);
            this.size += l.size;
        }
    }

    public int get(int index) {
        return index >= 0 && index < this.size ? this.array[index] : this.defVal;
    }

    public int indexOf(int value) {
        if (this.size == 0) {
            return -1;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] != value) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(int value) {
        return this.indexOf(value) != -1;
    }

    public int removeKey(int key) {
        if (key < 0 || key >= this.size) {
            return this.defVal;
        }
        int rem = this.get(key);
        --this.size;
        System.arraycopy(this.array, key + 1, this.array, key, this.size - key);
        return rem;
    }

    public int removeValue(int value) {
        return this.removeKey(this.indexOf(value));
    }

    public void set(int i, int value) {
        this.array[i] = value;
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public int[] toArray() {
        return this.toArray(null);
    }

    public int[] toArray(int[] a) {
        if (a == null || a.length != this.size) {
            a = new int[this.size];
        }
        if (this.size > 0) {
            System.arraycopy(this.array, 0, a, 0, this.size);
        }
        return a;
    }

    public List<Integer> toList() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        if (this.size == 0) {
            return l;
        }
        for (int i = 0; i < this.size; ++i) {
            l.add(this.array[i]);
        }
        return l;
    }

    public void sort() {
        if (this.size < 2) {
            return;
        }
        Arrays.sort(this.array, 0, this.size);
    }

    public int[] toSortedArray() {
        if (this.size == 0) {
            return new int[0];
        }
        int[] a = this.toArray();
        Arrays.sort(a);
        return a;
    }

    public int hashCode() {
        int h = 0;
        for (int i = 0; i < this.size; ++i) {
            h = h * 31 + this.array[i];
        }
        return h;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        IntList l = (IntList)o;
        if (this.size != l.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.array[i] == l.array[i]) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreOrder(IntList l) {
        if (l == null) {
            return false;
        }
        if (l == this) {
            return true;
        }
        if (this.size != l.size) {
            return false;
        }
        IntList l1 = l.copy();
        for (int i = 0; i < this.size; ++i) {
            l1.removeValue(this.array[i]);
        }
        return l1.isEmpty();
    }

    public String toString() {
        if (this.size == 0) {
            return "[ ]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        sb.append(' ');
        for (int i = 0; i < this.size; ++i) {
            sb.append(this.array[i]);
            if (i == this.size - 1) continue;
            sb.append(',');
            sb.append(' ');
        }
        sb.append(' ');
        sb.append(']');
        return sb.toString();
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IntIterator(this.array);
    }

    public IntList copy() {
        IntList l = new IntList(this.size);
        System.arraycopy(this.array, 0, l.array, 0, this.size);
        l.size = this.size;
        l.defVal = this.defVal;
        return l;
    }

    public Map<Integer, Boolean> getDifferenceMap(IntList newList) {
        int i;
        HashMap<Integer, Boolean> map = new HashMap<Integer, Boolean>();
        if (this.isEmpty() && newList.isEmpty()) {
            return map;
        }
        for (i = 0; i < this.size; ++i) {
            if (newList.contains(this.array[i])) continue;
            map.put(this.array[i], false);
        }
        for (i = 0; i < newList.size; ++i) {
            if (this.contains(newList.array[i])) continue;
            map.put(this.array[i], true);
        }
        return map;
    }

    public static IntList asList(int ... values) {
        IntList l = new IntList(values.length);
        l.addAll(values);
        return l;
    }

    public void setJson(JsonElement e) {
        this.clear();
        this.addAll(LMJsonUtils.fromIntArray(e));
    }

    public JsonElement getJson() {
        return LMJsonUtils.toIntArray(this.array);
    }

    public static class IntIterator
    implements Iterator<Integer> {
        public final int[] values;
        public int pos = -1;

        public IntIterator(int[] v) {
            this.values = v;
        }

        @Override
        public boolean hasNext() {
            return this.pos < this.values.length;
        }

        @Override
        public Integer next() {
            return this.values[++this.pos];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

