/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio;

import com.google.common.collect.Lists;
import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.EnderIOTab;
import crazypants.enderio.Log;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.api.tool.ITool;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.tool.ToolUtil;
import crazypants.util.FluidUtil;
import crazypants.util.ITankAccess;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class BlockEio
extends Block {
    protected final Class<? extends TileEntity> teClass;
    protected final String name;

    protected BlockEio(String name, Class<? extends TileEntity> teClass) {
        this(name, teClass, new Material(MapColor.field_151668_h));
    }

    protected BlockEio(String name, Class<? extends TileEntity> teClass, Material mat) {
        super(mat);
        this.teClass = teClass;
        this.name = name;
        this.func_149711_c(0.5f);
        this.func_149663_c(name);
        this.func_149672_a(Block.field_149777_j);
        this.setHarvestLevel("pickaxe", 0);
        this.func_149647_a(EnderIOTab.tabEnderIO);
    }

    protected void init() {
        GameRegistry.registerBlock((Block)this, (String)this.name);
        if (this.teClass != null) {
            GameRegistry.registerTileEntity(this.teClass, (String)(this.name + "TileEntity"));
        }
    }

    public boolean hasTileEntity(int metadata) {
        return this.teClass != null;
    }

    public TileEntity createTileEntity(World world, int metadata) {
        if (this.teClass != null) {
            try {
                return this.teClass.newInstance();
            }
            catch (Exception e) {
                Log.error("Could not create tile entity for block " + this.name + " for class " + this.teClass);
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister iIconRegister) {
        this.field_149761_L = iIconRegister.func_94245_a("enderio:" + this.name);
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int side, float par7, float par8, float par9) {
        if (this.shouldWrench(world, x, y, z, entityPlayer, side) && ToolUtil.breakBlockWithTool(this, world, x, y, z, entityPlayer)) {
            return true;
        }
        TileEntity te = world.func_147438_o(x, y, z);
        ITool tool = ToolUtil.getEquippedTool(entityPlayer);
        if (tool != null && !entityPlayer.func_70093_af() && te instanceof AbstractMachineEntity) {
            ((AbstractMachineEntity)te).toggleIoModeForFace(ForgeDirection.getOrientation((int)side));
            world.func_147471_g(x, y, z);
            return true;
        }
        if (entityPlayer.func_70093_af()) {
            return false;
        }
        if (te instanceof ITankAccess) {
            if (FluidUtil.fillInternalTankFromPlayerHandItem(world, x, y, z, entityPlayer, (ITankAccess)te)) {
                return true;
            }
            if (FluidUtil.fillPlayerHandItemFromInternalTank(world, x, y, z, entityPlayer, (ITankAccess)te)) {
                return true;
            }
        }
        return this.openGui(world, x, y, z, entityPlayer, side);
    }

    protected boolean shouldWrench(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        return true;
    }

    protected boolean openGui(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        return false;
    }

    public boolean doNormalDrops(World world, int x, int y, int z) {
        return true;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.func_149636_a(world, player, x, y, z, meta);
        world.func_147468_f(x, y, z);
    }

    public final ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        if (this.doNormalDrops(world, x, y, z)) {
            return super.getDrops(world, x, y, z, metadata, fortune);
        }
        return Lists.newArrayList((Object[])new ItemStack[]{this.getNBTDrop(world, x, y, z, (TileEntityEio)world.func_147438_o(x, y, z))});
    }

    public ItemStack getNBTDrop(World world, int x, int y, int z, TileEntityEio te) {
        int meta = this.func_149692_a(te.func_145832_p());
        ItemStack itemStack = new ItemStack((Block)this, 1, meta);
        this.processDrop(world, x, y, z, te, itemStack);
        return itemStack;
    }

    protected void processDrop(World world, int x, int y, int z, @Nullable TileEntityEio te, ItemStack drop) {
    }
}

