/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.List;

public class ConduitNetworkTickHandler {
    public static final ConduitNetworkTickHandler instance = new ConduitNetworkTickHandler();
    private final List<TickListener> listeners = new ArrayList<TickListener>();

    public void addListener(TickListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TickListener listener) {
        this.listeners.remove(listener);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            this.tickStart(event);
        } else {
            this.tickEnd(event);
        }
    }

    public void tickStart(TickEvent.ServerTickEvent event) {
        for (TickListener h : this.listeners) {
            h.tickStart(event);
        }
    }

    public void tickEnd(TickEvent.ServerTickEvent event) {
        for (TickListener h : this.listeners) {
            h.tickEnd(event);
        }
        this.listeners.clear();
    }

    public static interface TickListener {
        public void tickStart(TickEvent.ServerTickEvent var1);

        public void tickEnd(TickEvent.ServerTickEvent var1);
    }
}

