/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.facade;

import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.render.RenderUtil;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.IItemRenderer;
import org.lwjgl.opengl.GL11;

public class FacadeRenderer
implements IItemRenderer {
    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return type == IItemRenderer.ItemRenderType.ENTITY || type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.INVENTORY || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            RenderBlocks renderBlocks = (RenderBlocks)data[0];
            this.renderToInventory(item, renderBlocks);
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            this.renderEquipped(item, (RenderBlocks)data[0]);
        } else if (type == IItemRenderer.ItemRenderType.ENTITY) {
            this.renderEntity(item, (RenderBlocks)data[0]);
        } else {
            System.out.println("FacadeRenderer.renderItem: Unsupported render type");
        }
    }

    private void renderEntity(ItemStack item, RenderBlocks renderBlocks) {
        GL11.glPushMatrix();
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        this.renderToInventory(item, renderBlocks);
        GL11.glPopMatrix();
    }

    private void renderEquipped(ItemStack item, RenderBlocks renderBlocks) {
        this.renderToInventory(item, renderBlocks);
    }

    private void renderToInventory(ItemStack item, RenderBlocks renderBlocks) {
        Block block = PainterUtil.getSourceBlock(item);
        if (block != null) {
            RenderUtil.bindBlockTexture();
            if (!block.func_149662_c()) {
                GL11.glEnable((int)3042);
                GL11.glBlendFunc((int)770, (int)771);
            }
            if ("appeng.block.solids.BlockSkyStone".equals(block.getClass().getName())) {
                renderBlocks.func_147757_a(block.func_149691_a(0, PainterUtil.getSourceBlockMetadata(item)));
                renderBlocks.func_147800_a(Blocks.field_150348_b, 0, 1.0f);
            } else {
                renderBlocks.func_147800_a(block, PainterUtil.getSourceBlockMetadata(item), 1.0f);
            }
            GL11.glDepthFunc((int)515);
            GL11.glDisable((int)2896);
            GL11.glDepthMask((boolean)false);
            GL11.glEnable((int)3042);
            GL11.glBlendFunc((int)770, (int)771);
            GL11.glEnable((int)32823);
            GL11.glPolygonOffset((float)-1.0f, (float)-1.0f);
            RenderUtil.bindItemTexture();
            renderBlocks.func_147757_a(EnderIO.itemConduitFacade.getOverlayIcon());
            renderBlocks.func_147800_a(Blocks.field_150348_b, item.func_77960_j(), 1.0f);
            GL11.glDisable((int)32823);
            renderBlocks.func_147771_a();
            GL11.glDisable((int)3042);
            GL11.glDepthMask((boolean)true);
            GL11.glEnable((int)2896);
            GL11.glDepthFunc((int)515);
        } else {
            renderBlocks.func_147757_a(EnderIO.itemConduitFacade.func_77617_a(item.func_77960_j()));
            renderBlocks.func_147800_a(Blocks.field_150348_b, 0, 1.0f);
            renderBlocks.func_147771_a();
        }
    }
}

