/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.item.skull;

import cpw.mods.fml.client.registry.ISimpleBlockRenderingHandler;
import crazypants.enderio.EnderIO;
import crazypants.enderio.item.skull.BlockEndermanSkull;
import crazypants.enderio.item.skull.TileEndermanSkull;
import crazypants.render.BoundingBox;
import crazypants.render.CubeRenderer;
import crazypants.render.RenderUtil;
import crazypants.render.VertexRotation;
import crazypants.render.VertexTransform;
import crazypants.vecmath.Vector3d;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class EndermanSkullRenderer
implements ISimpleBlockRenderingHandler,
IItemRenderer {
    public void renderInventoryBlock(Block block, int metadata, int modelId, RenderBlocks renderer) {
        System.out.println("EndermanSkullRenderer.renderInventoryBlock: ");
        this.renderWorldBlock(null, 0, 0, 0, block, modelId, renderer);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        int meta = 0;
        if (world != null) {
            meta = world.func_72805_g(x, y, z);
        }
        return this.renderWorldBlock(world, x, y, z, block, modelId, renderer, meta);
    }

    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer, int meta) {
        TileEntity te;
        Tessellator tes = Tessellator.field_78398_a;
        tes.func_78372_c((float)x, (float)y, (float)z);
        tes.func_78386_a(1.0f, 1.0f, 1.0f);
        int brightness = world == null ? 0xF000F0 : world.func_72802_i(x, y, z, 0);
        tes.func_78380_c(brightness);
        IIcon[] icons = new IIcon[6];
        for (int i = 0; i < icons.length; ++i) {
            icons[i] = block.func_149691_a(i, meta);
        }
        float yaw = 180.0f;
        if (world != null && (te = world.func_147438_o(x, y, z)) instanceof TileEndermanSkull) {
            yaw = ((TileEndermanSkull)te).yaw;
        }
        VertexRotation rot = new VertexRotation(Math.toRadians(yaw), new Vector3d(0.0, 1.0, 0.0), new Vector3d(0.5, 0.0, 0.5));
        float size = 0.25f;
        float height = 0.5f;
        BoundingBox bb = new BoundingBox(size, 0.0f, size, 1.0f - size, height, 1.0f - size);
        if (renderer.func_147744_b()) {
            CubeRenderer.render(bb, renderer.field_147840_d, (VertexTransform)rot);
        } else {
            CubeRenderer.render(bb, icons, (VertexTransform)rot, true);
            if (meta > 1) {
                this.renderBolts(rot, size);
            }
        }
        tes.func_78372_c((float)(-x), (float)(-y), (float)(-z));
        return true;
    }

    private void renderBolts(VertexRotation rot, float size) {
        float boltSize = size / 3.0f;
        BoundingBox baseBolt = BoundingBox.UNIT_CUBE.scale(boltSize, boltSize, boltSize);
        IIcon icon = EnderIO.blockSoulFuser.func_149691_a(ForgeDirection.EAST.ordinal(), 0);
        float offset = 0.15f;
        BoundingBox bb = baseBolt.translate(size + boltSize / 2.0f, -0.15f, offset);
        CubeRenderer.render(bb, icon, (VertexTransform)rot, true);
        bb = baseBolt.translate(size + boltSize / 2.0f, -0.15f, -offset);
        CubeRenderer.render(bb, icon, (VertexTransform)rot, true);
        bb = baseBolt.translate(-(size + boltSize / 2.0f), -0.15f, offset);
        CubeRenderer.render(bb, icon, (VertexTransform)rot, true);
        bb = baseBolt.translate(-(size + boltSize / 2.0f), -0.15f, -offset);
        CubeRenderer.render(bb, icon, (VertexTransform)rot, true);
        bb = baseBolt.translate(-offset, -0.15f, -(size + boltSize / 2.0f));
        CubeRenderer.render(bb, icon, (VertexTransform)rot, true);
        bb = baseBolt.translate(offset, -0.15f, -(size + boltSize / 2.0f));
        CubeRenderer.render(bb, icon, (VertexTransform)rot, true);
        bb = baseBolt.translate(offset, -0.15f, size + boltSize / 2.0f);
        CubeRenderer.render(bb, icon, (VertexTransform)rot, true);
        bb = baseBolt.translate(-offset, -0.15f, size + boltSize / 2.0f);
        CubeRenderer.render(bb, icon, (VertexTransform)rot, true);
    }

    public boolean shouldRender3DInInventory(int modelId) {
        return true;
    }

    public int getRenderId() {
        return BlockEndermanSkull.renderId;
    }

    public boolean handleRenderType(ItemStack item, IItemRenderer.ItemRenderType type) {
        return true;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return true;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack item, Object ... data) {
        Tessellator.field_78398_a.func_78382_b();
        GL11.glPushMatrix();
        float scale = 2.5f;
        float xTrans = -0.5f;
        float yTrans = 0.0f;
        float zTrans = -0.5f;
        if (type == IItemRenderer.ItemRenderType.INVENTORY) {
            yTrans = -0.25f;
            scale = 1.8f;
        } else if (type == IItemRenderer.ItemRenderType.EQUIPPED || type == IItemRenderer.ItemRenderType.EQUIPPED_FIRST_PERSON) {
            scale = 1.8f;
            yTrans = 0.0f;
            zTrans = -0.25f;
            xTrans = -0.25f;
        }
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        GL11.glTranslatef((float)xTrans, (float)yTrans, (float)zTrans);
        RenderUtil.bindBlockTexture();
        this.renderWorldBlock(null, 0, 0, 0, EnderIO.blockEndermanSkull, this.getRenderId(), (RenderBlocks)data[0], item.func_77960_j());
        Tessellator.field_78398_a.func_78381_a();
        GL11.glPopMatrix();
    }
}

