/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.buffer;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import crazypants.enderio.machine.IoMode;
import crazypants.enderio.machine.buffer.ContainerBuffer;
import crazypants.enderio.machine.buffer.PacketBufferIO;
import crazypants.enderio.machine.buffer.TileBuffer;
import crazypants.enderio.machine.gui.GuiPoweredMachineBase;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.enderio.network.PacketHandler;
import crazypants.render.RenderUtil;
import crazypants.util.Lang;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Slot;
import org.lwjgl.opengl.GL11;

public class GuiBuffer
extends GuiPoweredMachineBase<TileBuffer> {
    private static final String TEXTURE_SIMPLE = "enderio:textures/gui/buffer.png";
    private static final String TEXTURE_FULL = "enderio:textures/gui/buffer_full.png";
    private GuiTextField maxInput;
    private GuiTextField maxOutput;
    private int lastInput;
    private int lastOutput;

    public GuiBuffer(InventoryPlayer par1InventoryPlayer, TileBuffer te) {
        super(te, new ContainerBuffer(par1InventoryPlayer, te));
        this.redstoneButton.setPosition(this.isFull() ? 153 : 120, 24);
        this.configB.setPosition(this.isFull() ? 153 : 120, 42);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        int x = this.field_147003_i + (this.isFull() ? 20 : 58);
        int y = this.field_147009_r + 27;
        this.maxInput = new GuiTextField(this.getFontRenderer(), x, y, 60, 12);
        this.maxInput.func_146205_d(true);
        this.maxInput.func_146203_f(10);
        this.maxInput.func_146195_b(false);
        this.maxInput.func_146180_a(PowerDisplayUtil.formatPower(((TileBuffer)this.getTileEntity()).getMaxInput()));
        this.maxOutput = new GuiTextField(this.getFontRenderer(), x, y += 28, 60, 12);
        this.maxOutput.func_146205_d(true);
        this.maxOutput.func_146203_f(10);
        this.maxOutput.func_146195_b(((TileBuffer)this.getTileEntity()).hasPower());
        this.maxOutput.func_146180_a(PowerDisplayUtil.formatPower(((TileBuffer)this.getTileEntity()).getMaxOutput()));
    }

    @Override
    protected void func_73869_a(char par1, int par2) {
        super.func_73869_a(par1, par2);
        if (par1 == 'e') {
            super.func_73869_a(par1, 1);
        }
        if (((TileBuffer)this.getTileEntity()).hasPower()) {
            this.maxInput.func_146201_a(par1, par2);
            this.maxOutput.func_146201_a(par1, par2);
            this.updateInputOutput();
        }
    }

    private void updateInputOutput() {
        int input = PowerDisplayUtil.parsePower(this.maxInput);
        this.setMaxInput(input);
        int output = PowerDisplayUtil.parsePower(this.maxOutput);
        this.setMaxOutput(output);
        this.sendUpdateToServer();
    }

    private void setMaxOutput(int output) {
        if (output != this.lastOutput) {
            this.lastOutput = output;
            this.maxOutput.func_146180_a(PowerDisplayUtil.formatPower(output));
        }
    }

    private void setMaxInput(int input) {
        if (input != this.lastInput) {
            this.lastInput = input;
            this.maxInput.func_146180_a(PowerDisplayUtil.formatPower(input));
            this.sendUpdateToServer();
        }
    }

    protected void sendUpdateToServer() {
        PacketHandler.INSTANCE.sendToServer((IMessage)new PacketBufferIO((TileBuffer)this.getTileEntity(), this.lastInput, this.lastOutput));
    }

    protected void func_73864_a(int par1, int par2, int par3) {
        super.func_73864_a(par1, par2, par3);
        if (((TileBuffer)this.getTileEntity()).hasPower()) {
            this.maxInput.func_146192_a(par1, par2, par3);
            this.maxOutput.func_146192_a(par1, par2, par3);
        }
    }

    public void func_73876_c() {
        if (((TileBuffer)this.getTileEntity()).hasPower()) {
            this.maxInput.func_146178_a();
            this.maxOutput.func_146178_a();
        }
    }

    @Override
    protected boolean showRecipeButton() {
        return false;
    }

    @Override
    protected boolean renderPowerBar() {
        return ((TileBuffer)this.getTileEntity()).hasPower();
    }

    @Override
    public int getYSize() {
        return this.field_147000_g;
    }

    @Override
    protected int getPowerHeight() {
        return 52;
    }

    @Override
    protected int getPowerX() {
        return this.isFull() ? 6 : 44;
    }

    @Override
    protected int getPowerY() {
        return 15;
    }

    @Override
    protected int getPowerV() {
        return 0;
    }

    @Override
    protected void func_146976_a(float par1, int par2, int par3) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderUtil.bindTexture(this.isFull() ? TEXTURE_FULL : TEXTURE_SIMPLE);
        int sx = (this.field_146294_l - this.field_146999_f) / 2;
        int sy = (this.field_146295_m - this.field_147000_g) / 2;
        this.func_73729_b(sx, sy, 0, 0, this.field_146999_f, this.field_147000_g);
        RenderUtil.bindTexture(TEXTURE_SIMPLE);
        if (((TileBuffer)this.getTileEntity()).hasPower()) {
            this.drawPowerBg(sx, sy);
        }
        if (((TileBuffer)this.getTileEntity()).hasInventory()) {
            this.drawSlotBg(sx, sy);
        }
        super.func_146976_a(par1, par2, par3);
        String invName = Lang.localize(((TileBuffer)this.getTileEntity()).func_145825_b() + ".name", false);
        this.getFontRenderer().func_78261_a(invName, sx + this.field_146999_f / 2 - this.getFontRenderer().func_78256_a(invName) / 2, sy + 4, 0xFFFFFF);
        if (((TileBuffer)this.getTileEntity()).hasPower()) {
            this.getFontRenderer().func_78261_a(Lang.localize("gui.simple.in"), sx += this.isFull() ? 19 : 57, sy += 17, 0xFFFFFF);
            this.getFontRenderer().func_78261_a(Lang.localize("gui.simple.out"), sx, sy + 27, 0xFFFFFF);
            this.maxInput.func_146194_f();
            this.maxOutput.func_146194_f();
        }
    }

    boolean isFull() {
        return ((TileBuffer)this.getTileEntity()).hasInventory() && ((TileBuffer)this.getTileEntity()).hasPower();
    }

    @Override
    public void renderSlotHighlights(IoMode mode) {
        if (!((TileBuffer)this.getTileEntity()).hasInventory()) {
            return;
        }
        for (int slot = 0; slot < ((TileBuffer)this.getTileEntity()).func_70302_i_(); ++slot) {
            this.renderSlotHighlight(slot, mode);
        }
    }

    protected void renderSlotHighlight(int slot, IoMode mode) {
        Slot invSlot = (Slot)this.field_147002_h.field_75151_b.get(slot);
        if (mode == IoMode.PULL) {
            this.renderSlotHighlight(slot, PULL_COLOR);
        } else if (mode == IoMode.PUSH) {
            this.renderSlotHighlight(slot, PUSH_COLOR);
        } else if (mode == IoMode.PUSH_PULL) {
            this.renderSplitHighlight(invSlot.field_75223_e, invSlot.field_75221_f, 16, 16);
        }
    }

    protected void renderSplitHighlight(int x, int y, int width, int height) {
        GL11.glEnable((int)3042);
        RenderUtil.renderQuad2D((double)(this.getGuiLeft() + x), (double)(this.getGuiTop() + y), 0.0, (double)width, (double)(height / 2), PULL_COLOR);
        RenderUtil.renderQuad2D((double)(this.getGuiLeft() + x), (double)(this.getGuiTop() + y + height / 2), 0.0, (double)width, (double)(height / 2), PUSH_COLOR);
        GL11.glDisable((int)3042);
    }

    private void drawPowerBg(int sx, int sy) {
        this.func_73729_b(sx + (this.isFull() ? 5 : 43), sy + 14, this.field_146999_f + 10, 0, 12, 54);
    }

    private void drawSlotBg(int sx, int sy) {
        this.func_73729_b(sx + (this.isFull() ? 95 : 61), sy + 14, this.field_146999_f + 22, 0, 54, 54);
    }
}

