/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.CustomSeedFarmer;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.util.BlockCoord;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class StemFarmer
extends CustomSeedFarmer {
    private static final HeightCompatator COMP = new HeightCompatator();

    public StemFarmer(Block plantedBlock, ItemStack seeds) {
        super(plantedBlock, seeds);
    }

    @Override
    public boolean prepareBlock(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        if (this.plantedBlock == block) {
            return true;
        }
        return this.plantFromInventory(farm, bc);
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        BlockCoord up = bc.getLocation(ForgeDirection.UP);
        Block upBLock = farm.getBlock(up);
        return upBLock == this.plantedBlock;
    }

    @Override
    public boolean canPlant(ItemStack stack) {
        return this.seeds.func_77969_a(stack);
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        HarvestResult res = new HarvestResult();
        BlockCoord harvestCoord = bc;
        boolean done = false;
        do {
            if (this.plantedBlock == farm.getBlock(harvestCoord = harvestCoord.getLocation(ForgeDirection.UP)) && farm.hasHoe()) {
                res.harvestedBlocks.add(harvestCoord);
                ArrayList drops = this.plantedBlock.getDrops(farm.func_145831_w(), harvestCoord.x, harvestCoord.y, harvestCoord.z, meta, farm.getMaxLootingValue());
                if (drops != null) {
                    for (ItemStack drop : drops) {
                        res.drops.add(new EntityItem(farm.func_145831_w(), (double)bc.x + 0.5, (double)bc.y + 0.5, (double)bc.z + 0.5, drop.func_77946_l()));
                    }
                }
                farm.damageHoe(1, harvestCoord);
                farm.actionPerformed(false);
                continue;
            }
            done = true;
        } while (!done);
        ArrayList<BlockCoord> toClear = new ArrayList<BlockCoord>(res.getHarvestedBlocks());
        Collections.sort(toClear, COMP);
        for (BlockCoord coord : toClear) {
            farm.func_145831_w().func_147468_f(coord.x, coord.y, coord.z);
        }
        return res;
    }

    @Override
    protected boolean plantFromInventory(TileFarmStation farm, BlockCoord bc) {
        World worldObj = farm.func_145831_w();
        if (this.canPlant(worldObj, bc) && farm.takeSeedFromSupplies(this.seeds, bc) != null) {
            return this.plant(farm, worldObj, bc);
        }
        return false;
    }

    private static class HeightCompatator
    implements Comparator<BlockCoord> {
        private HeightCompatator() {
        }

        @Override
        public int compare(BlockCoord o1, BlockCoord o2) {
            return -HeightCompatator.compare(o1.y, o2.y);
        }

        public static int compare(int x, int y) {
            return x < y ? -1 : (x == y ? 0 : 1);
        }
    }
}

