/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import crazypants.enderio.Log;
import crazypants.enderio.machine.hypercube.Channel;
import crazypants.enderio.machine.hypercube.HyperCubeConfig;
import crazypants.enderio.machine.hypercube.TileHyperCube;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.DimensionManager;

public class HyperCubeRegister {
    private static final String CATEGORY_PUBLIC_CHANNELS = "PublicChannels";
    private static final String CATEGORY_PRIVATE_CHANNELS = "PrivateChannels";
    private static final String KEY_PUBLIC_CHANNELS = "names";
    public static HyperCubeRegister instance;
    private final Map<Channel, List<TileHyperCube>> channelMapping = new HashMap<Channel, List<TileHyperCube>>();
    private final List<Channel> publicChannels = new ArrayList<Channel>();
    private final List<Channel> publicChannelsRO = Collections.unmodifiableList(this.publicChannels);
    private final Map<String, List<Channel>> userChannels = new HashMap<String, List<Channel>>();
    private HyperCubeConfig conf;

    public static void load() {
        instance = new HyperCubeRegister();
        instance.innerLoad();
    }

    public static void unload() {
        instance = new HyperCubeRegister();
    }

    private void innerLoad() {
        File f = DimensionManager.getCurrentSaveRootDirectory();
        this.conf = new HyperCubeConfig(new File(DimensionManager.getCurrentSaveRootDirectory(), "enderio/dimensionalTransceiver.cfg"));
        this.publicChannels.addAll(this.conf.getPublicChannels());
        this.userChannels.putAll(this.conf.getUserChannels());
    }

    public synchronized List<Channel> getChannelsForUser(String user) {
        List<Channel> result = this.userChannels.get(user);
        if (result == null) {
            result = new ArrayList<Channel>();
            this.userChannels.put(user, result);
        }
        return result;
    }

    public synchronized void register(TileHyperCube cube) {
        List<TileHyperCube> cubes = this.innerGetCubesForChannel(cube.getChannel());
        if (cubes != null && !cubes.contains(cube)) {
            cubes.add(cube);
        }
    }

    public synchronized void deregister(TileHyperCube cube, Channel channel) {
        List<TileHyperCube> cubes = this.innerGetCubesForChannel(channel);
        if (cubes != null) {
            cubes.remove(cube);
        }
    }

    public synchronized void deregister(TileHyperCube cube) {
        List<TileHyperCube> cubes = this.innerGetCubesForChannel(cube.getChannel());
        if (cubes != null) {
            cubes.remove(cube);
        }
    }

    public synchronized List<TileHyperCube> getCubesForChannel(Channel channel) {
        List<TileHyperCube> chans = this.innerGetCubesForChannel(channel);
        if (chans == null) {
            return Collections.emptyList();
        }
        return new ArrayList<TileHyperCube>(chans);
    }

    public synchronized void addChannel(Channel channel) {
        if (channel == null || channel.name == null) {
            return;
        }
        if (channel.user == null) {
            if (!this.publicChannels.contains(channel)) {
                this.publicChannels.add(channel);
                this.updateConfig();
            }
        } else {
            List<Channel> channels = this.getChannelsForUser(channel.user);
            if (!channels.contains(channel)) {
                channels.add(channel);
                this.updateConfig();
            }
        }
    }

    public void removeChannel(Channel channel) {
        if (channel == null || channel.name == null) {
            return;
        }
        if (channel.user == null) {
            if (this.publicChannels.contains(channel)) {
                this.publicChannels.remove(channel);
                this.updateConfig();
            }
        } else {
            List<Channel> channels = this.getChannelsForUser(channel.user);
            if (channels.contains(channel)) {
                channels.remove(channel);
                this.updateConfig();
            }
        }
    }

    private void updateConfig() {
        if (this.conf == null) {
            Log.warn("HyperCubeRegister.updateConfig: Config was null.");
            return;
        }
        this.conf.setPublicChannels(this.publicChannels);
        this.conf.setUserChannels(this.userChannels);
        this.conf.save();
    }

    private List<TileHyperCube> innerGetCubesForChannel(Channel channel) {
        if (channel == null) {
            return null;
        }
        List<TileHyperCube> result = this.channelMapping.get(channel);
        if (result == null) {
            result = new ArrayList<TileHyperCube>();
            this.channelMapping.put(channel, result);
        }
        return result;
    }

    public List<Channel> getPublicChannels() {
        return this.publicChannelsRO;
    }
}

