/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.light;

import cpw.mods.fml.common.registry.GameRegistry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.ModObject;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.api.redstone.IRedstoneConnectable;
import crazypants.enderio.machine.light.BlockItemElectricLight;
import crazypants.enderio.machine.light.TileElectricLight;
import crazypants.vecmath.Vector3f;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockElectricLight
extends BlockEio
implements IRedstoneConnectable {
    static final float BLOCK_HEIGHT = 0.05f;
    static final float BLOCK_WIDTH = 0.3f;
    static final float BLOCK_EDGE_MAX = 0.65f;
    static final float BLOCK_EDGE_MIN = 0.35f;
    public static int renderId;
    private IIcon blockIconOff;
    private IIcon blockIconSide;

    public static BlockElectricLight create() {
        BlockElectricLight result = new BlockElectricLight();
        result.init();
        return result;
    }

    public BlockElectricLight() {
        super(ModObject.blockElectricLight.unlocalisedName, TileElectricLight.class);
        this.func_149713_g(0);
        this.func_149676_a(0.35f, 0.0f, 0.35f, 0.65f, 0.05f, 0.65f);
    }

    @Override
    protected void init() {
        GameRegistry.registerBlock((Block)this, BlockItemElectricLight.class, (String)ModObject.blockElectricLight.unlocalisedName);
        GameRegistry.registerTileEntity(TileElectricLight.class, (String)(ModObject.blockElectricLight.unlocalisedName + "TileEntity"));
    }

    public AxisAlignedBB func_149668_a(World world, int x, int y, int z) {
        return null;
    }

    @Override
    public void func_149651_a(IIconRegister iIconRegister) {
        this.field_149761_L = iIconRegister.func_94245_a("enderio:blockElectricLightFace");
        this.blockIconOff = iIconRegister.func_94245_a("enderio:blockElectricLightFaceOff");
        this.blockIconSide = iIconRegister.func_94245_a("enderio:conduitConnector");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof TileElectricLight) {
            ForgeDirection onFace = ((TileElectricLight)te).getFace();
            if (side == onFace.getOpposite().ordinal()) {
                boolean on = blockAccess.func_72805_g(x, y, z) != 0;
                return on ? this.field_149761_L : this.blockIconOff;
            }
            return this.blockIconSide;
        }
        return this.func_149691_a(side, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_149691_a(int side, int par2) {
        if (side == ForgeDirection.UP.ordinal()) {
            return this.field_149761_L;
        }
        return this.blockIconSide;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return renderId;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        Block block = world.func_147439_a(x, y, z);
        if (block != null && block != this) {
            return block.getLightValue(world, x, y, z);
        }
        return world.func_72805_g(x, y, z) > 0 ? 15 : 0;
    }

    public void func_149719_a(IBlockAccess blockAccess, int x, int y, int z) {
        ForgeDirection onFace = ForgeDirection.DOWN;
        TileEntity te = blockAccess.func_147438_o(x, y, z);
        if (te instanceof TileElectricLight) {
            onFace = ((TileElectricLight)te).getFace();
        }
        Vector3f min = new Vector3f();
        Vector3f max = new Vector3f();
        switch (onFace) {
            case UP: {
                min.set(0.35f, 0.95f, 0.35f);
                max.set(0.65f, 1.0f, 0.65f);
                break;
            }
            case DOWN: {
                min.set(0.35f, 0.0f, 0.35f);
                max.set(0.65f, 0.05f, 0.65f);
                break;
            }
            case EAST: {
                min.set(0.95f, 0.35f, 0.35f);
                max.set(1.0f, 0.65f, 0.65f);
                break;
            }
            case WEST: {
                min.set(0.0f, 0.35f, 0.35f);
                max.set(0.05f, 0.65f, 0.65f);
                break;
            }
            case NORTH: {
                min.set(0.35f, 0.35f, 0.0f);
                max.set(0.65f, 0.65f, 0.05f);
                break;
            }
            case SOUTH: {
                min.set(0.35f, 0.35f, 0.95f);
                max.set(0.65f, 0.65f, 1.0f);
                break;
            }
            default: {
                min.set(0.35f, 0.0f, 0.35f);
                max.set(0.65f, 0.05f, 0.65f);
            }
        }
        this.func_149676_a(min.x, min.y, min.z, max.x, max.y, max.z);
    }

    public void func_149683_g() {
        this.func_149676_a(0.35f, 0.0f, 0.35f, 0.65f, 0.05f, 0.65f);
    }

    public boolean func_149662_c() {
        return false;
    }

    public void func_149695_a(World world, int x, int y, int z, Block blockID) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileElectricLight) {
            ((TileElectricLight)te).onNeighborBlockChange(blockID);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block par5, int par6) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileElectricLight) {
            ((TileElectricLight)te).onBlockRemoved();
        }
    }

    @Override
    protected void processDrop(World world, int x, int y, int z, TileEntityEio te, ItemStack drop) {
        int meta;
        TileElectricLight light = (TileElectricLight)te;
        if (light == null) {
            return;
        }
        int n = meta = light.isInvereted() ? 1 : 0;
        if (!light.isRequiresPower()) {
            meta += 2;
        } else if (light.isWireless()) {
            meta += 4;
        }
        drop.func_77964_b(meta);
    }

    @Override
    public boolean doNormalDrops(World world, int x, int y, int z) {
        return false;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        ItemStack stack = new ItemStack((Block)this);
        if (te instanceof TileElectricLight) {
            this.processDrop(world, x, y, z, (TileEntityEio)te, stack);
        }
        return stack;
    }

    @Override
    public boolean shouldRedstoneConduitConnect(World world, int x, int y, int z, ForgeDirection from) {
        return true;
    }
}

