/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.solar;

import cofh.api.energy.EnergyStorage;
import cpw.mods.fml.common.registry.GameRegistry;
import crazypants.enderio.BlockEio;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.gui.IResourceTooltipProvider;
import crazypants.enderio.machine.solar.BlockItemSolarPanel;
import crazypants.enderio.machine.solar.TileEntitySolarPanel;
import crazypants.enderio.waila.IWailaInfoProvider;
import crazypants.enderio.waila.WailaCompat;
import crazypants.util.Lang;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockSolarPanel
extends BlockEio
implements IResourceTooltipProvider,
IWailaInfoProvider {
    public static int renderId;
    private static final float BLOCK_HEIGHT = 0.15f;
    IIcon sideIcon;
    IIcon advancedSideIcon;
    IIcon advancedIcon;
    IIcon borderIcon;
    IIcon advancedBorderIcon;

    public static BlockSolarPanel create() {
        BlockSolarPanel result = new BlockSolarPanel();
        result.init();
        return result;
    }

    private BlockSolarPanel() {
        super(ModObject.blockSolarPanel.unlocalisedName, TileEntitySolarPanel.class);
        if (!Config.photovoltaicCellEnabled) {
            this.func_149647_a(null);
        }
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.15f, 1.0f);
    }

    @Override
    protected void init() {
        GameRegistry.registerBlock((Block)this, BlockItemSolarPanel.class, (String)this.name);
        if (this.teClass != null) {
            GameRegistry.registerTileEntity((Class)this.teClass, (String)(this.name + "TileEntity"));
        }
    }

    public int func_149692_a(int damage) {
        return damage;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public IIcon func_149691_a(int side, int meta) {
        if (side == ForgeDirection.UP.ordinal()) {
            return meta == 0 ? this.field_149761_L : this.advancedIcon;
        }
        return meta == 0 ? this.sideIcon : this.advancedSideIcon;
    }

    public IIcon getBorderIcon(int i, int meta) {
        return meta == 0 ? this.borderIcon : this.advancedBorderIcon;
    }

    public int func_149645_b() {
        return renderId;
    }

    public void func_149695_a(World world, int x, int y, int z, Block par5) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntitySolarPanel) {
            ((TileEntitySolarPanel)te).onNeighborBlockChange();
        }
    }

    @Override
    public void func_149651_a(IIconRegister register) {
        this.field_149761_L = register.func_94245_a("enderio:solarPanelTop");
        this.advancedIcon = register.func_94245_a("enderio:solarPanelAdvancedTop");
        this.sideIcon = register.func_94245_a("enderio:solarPanelSide");
        this.advancedSideIcon = register.func_94245_a("enderio:solarPanelAdvancedSide");
        this.borderIcon = register.func_94245_a("enderio:solarPanelBorder");
        this.advancedBorderIcon = register.func_94245_a("enderio:solarPanelAdvancedBorder");
    }

    public void func_149719_a(IBlockAccess par1IBlockAccess, int par2, int par3, int par4) {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.15f, 1.0f);
    }

    public void func_149683_g() {
        this.func_149676_a(0.0f, 0.0f, 0.0f, 1.0f, 0.15f, 1.0f);
    }

    public void func_149743_a(World par1World, int par2, int par3, int par4, AxisAlignedBB par5AxisAlignedBB, List par6List, Entity par7Entity) {
        this.func_149719_a((IBlockAccess)par1World, par2, par3, par4);
        super.func_149743_a(par1World, par2, par3, par4, par5AxisAlignedBB, par6List, par7Entity);
    }

    @Override
    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_149739_a();
    }

    @Override
    public void getWailaInfo(List<String> tooltip, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileEntitySolarPanel) {
            TileEntitySolarPanel solar = (TileEntitySolarPanel)te;
            float efficiency = solar.calculateLightRatio();
            EnergyStorage storage = new EnergyStorage(Integer.MAX_VALUE);
            storage.readFromNBT(WailaCompat.getNBTData());
            tooltip.add(storage.getEnergyStored() + " / " + WailaCompat.getNBTData().func_74762_e("rfCap") + " RF");
            tooltip.add(String.format("%s : %s%.0f%%", EnumChatFormatting.WHITE + Lang.localize("tooltip.efficiency") + EnumChatFormatting.RESET, EnumChatFormatting.WHITE, Float.valueOf(efficiency * 100.0f)));
        }
    }

    @Override
    public int getDefaultDisplayMask(World world, int x, int y, int z) {
        return 0;
    }
}

