/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.soul;

import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.config.Config;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.recipe.RecipeBonusType;
import crazypants.enderio.machine.soul.ISoulBinderRecipe;
import crazypants.enderio.machine.spawner.ItemBrokenSpawner;
import crazypants.enderio.machine.spawner.PoweredSpawnerConfig;
import crazypants.util.EntityUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class SoulBinderSpawnerRecipe
implements IMachineRecipe,
ISoulBinderRecipe {
    public static SoulBinderSpawnerRecipe instance = new SoulBinderSpawnerRecipe();

    @Override
    public String getUid() {
        return "SoulFuserSpawnerRecipe";
    }

    @Override
    public int getEnergyRequired(MachineRecipeInput ... inputs) {
        return Config.soulBinderBrokenSpawnerRF;
    }

    @Override
    public RecipeBonusType getBonusType(MachineRecipeInput ... inputs) {
        return RecipeBonusType.NONE;
    }

    @Override
    public int getExperienceRequired() {
        return Config.soulBinderBrokenSpawnerLevels;
    }

    @Override
    public boolean isRecipe(MachineRecipeInput ... inputs) {
        int validCount = 0;
        for (MachineRecipeInput input : inputs) {
            if (this.isValidInput(input)) {
                ++validCount;
                continue;
            }
            return false;
        }
        return validCount == 2;
    }

    @Override
    public IMachineRecipe.ResultStack[] getCompletedResult(float randomChance, MachineRecipeInput ... inputs) {
        String mobType = null;
        for (MachineRecipeInput input : inputs) {
            if (input == null || !EnderIO.itemSoulVessel.containsSoul(input.item)) continue;
            mobType = EnderIO.itemSoulVessel.getMobTypeFromStack(input.item);
        }
        if (mobType == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        ItemStack spawner = ItemBrokenSpawner.createStackForMobType(mobType);
        if (spawner == null) {
            return new IMachineRecipe.ResultStack[0];
        }
        ItemStack soulVessel = new ItemStack((Item)EnderIO.itemSoulVessel);
        return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(soulVessel), new IMachineRecipe.ResultStack(spawner)};
    }

    @Override
    public float getExperienceForOutput(ItemStack output) {
        return 0.0f;
    }

    @Override
    public boolean isValidInput(MachineRecipeInput input) {
        if (input == null || input.item == null) {
            return false;
        }
        int slot = input.slotNumber;
        ItemStack item = input.item;
        if (slot == 0) {
            String mobType = EnderIO.itemSoulVessel.getMobTypeFromStack(item);
            return mobType != null && !EnderIO.blockPoweredSpawner.isBlackListed(mobType);
        }
        if (slot == 1) {
            return item.func_77973_b() == EnderIO.itemBrokenSpawner;
        }
        return false;
    }

    private boolean isBlackListed(String entityId) {
        return PoweredSpawnerConfig.getInstance().isBlackListed(entityId);
    }

    @Override
    public String getMachineName() {
        return ModObject.blockSoulBinder.unlocalisedName;
    }

    @Override
    public List<MachineRecipeInput> getQuantitiesConsumed(MachineRecipeInput[] inputs) {
        ArrayList<MachineRecipeInput> result = new ArrayList<MachineRecipeInput>(inputs.length);
        for (MachineRecipeInput input : inputs) {
            if (input == null || input.item == null) continue;
            ItemStack resStack = input.item.func_77946_l();
            resStack.field_77994_a = 1;
            MachineRecipeInput mri = new MachineRecipeInput(input.slotNumber, resStack);
            result.add(mri);
        }
        return result;
    }

    @Override
    public ItemStack getInputStack() {
        return new ItemStack((Item)EnderIO.itemBrokenSpawner);
    }

    @Override
    public ItemStack getOutputStack() {
        return new ItemStack((Item)EnderIO.itemBrokenSpawner);
    }

    @Override
    public List<String> getSupportedSouls() {
        List<String> res = EntityUtil.getAllRegisteredMobNames(!Config.soulVesselCapturesBosses);
        return res;
    }

    @Override
    public int getEnergyRequired() {
        return Config.soulBinderBrokenSpawnerRF;
    }
}

