/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.machine.transceiver.Channel;
import crazypants.enderio.machine.transceiver.ChannelRegister;
import crazypants.enderio.machine.transceiver.ClientChannelRegister;
import crazypants.enderio.machine.transceiver.ServerChannelRegister;
import crazypants.enderio.network.NetworkUtil;
import crazypants.enderio.network.PacketHandler;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;

public class PacketAddRemoveChannel
implements IMessage,
IMessageHandler<PacketAddRemoveChannel, IMessage> {
    private boolean isAdd;
    private Channel channel;

    public PacketAddRemoveChannel() {
    }

    public PacketAddRemoveChannel(Channel channel, boolean isAdd) {
        this.channel = channel;
        this.isAdd = isAdd;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.isAdd);
        NBTTagCompound nbt = new NBTTagCompound();
        this.channel.writeToNBT(nbt);
        NetworkUtil.writeNBTTagCompound(nbt, buf);
    }

    public void fromBytes(ByteBuf buf) {
        this.isAdd = buf.readBoolean();
        NBTTagCompound tag = NetworkUtil.readNBTTagCompound(buf);
        this.channel = Channel.readFromNBT(tag);
    }

    public IMessage onMessage(PacketAddRemoveChannel message, MessageContext ctx) {
        ChannelRegister register;
        ChannelRegister channelRegister = register = ctx.side == Side.CLIENT ? ClientChannelRegister.instance : ServerChannelRegister.instance;
        if (message.isAdd) {
            register.addChannel(message.channel);
        } else {
            register.removeChannel(message.channel);
        }
        if (ctx.side == Side.SERVER) {
            PacketHandler.INSTANCE.sendToAll((IMessage)new PacketAddRemoveChannel(message.channel, message.isAdd));
        }
        return null;
    }
}

